/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.service.impl;

import com.nimbusds.jose.CompressionAlgorithm;
import com.nimbusds.jose.JWEHeader;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.adorsys.encobject.domain.ContentMetaInfo;
import org.apache.commons.lang3.StringUtils;

public class ContentMetaInfoUtils {
    public static final void header2MetaInfo(JWEHeader header, ContentMetaInfo metaIno) {
        metaIno.setAddInfos(new HashMap<String, Object>());
        Map customParams = header.getCustomParams();
        if (customParams != null) {
            Object exp;
            metaIno.getAddInfos().putAll(customParams);
            if (customParams.containsKey("exp") && (exp = customParams.get("exp")) instanceof Long) {
                metaIno.setExp(new Date((Long)exp));
            }
        }
        if (header.getCompressionAlgorithm() != null) {
            metaIno.setZip(header.getCompressionAlgorithm().getName());
        }
        if (header.getContentType() != null) {
            metaIno.setContentTrype(header.getContentType());
        }
    }

    public static final JWEHeader.Builder metaInfo2Header(ContentMetaInfo metaIno, JWEHeader.Builder headerBuilder) {
        String zip;
        String contentTrype = metaIno.getContentTrype();
        if (StringUtils.isNotBlank((CharSequence)contentTrype)) {
            headerBuilder = headerBuilder.contentType(contentTrype);
        }
        if (StringUtils.isNotBlank((CharSequence)(zip = metaIno.getZip()))) {
            headerBuilder = headerBuilder.compressionAlgorithm(CompressionAlgorithm.DEF);
        } else if (StringUtils.isNotBlank((CharSequence)contentTrype) && StringUtils.containsIgnoreCase((CharSequence)contentTrype, (CharSequence)"text")) {
            headerBuilder = headerBuilder.compressionAlgorithm(CompressionAlgorithm.DEF);
        }
        Map<String, Object> addInfos = metaIno.getAddInfos();
        if (metaIno.getExp() != null) {
            if (addInfos == null) {
                addInfos = new HashMap<String, Object>();
            }
            addInfos.put("exp", metaIno.getExp().getTime());
        }
        if (addInfos != null) {
            headerBuilder = headerBuilder.customParams(addInfos);
        }
        return headerBuilder;
    }
}

