/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.service.impl;

import java.security.Key;
import java.security.KeyStore;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.encobject.domain.ReadKeyPassword;
import org.adorsys.encobject.service.api.KeySource;
import org.adorsys.encobject.types.KeyID;

public class KeyStoreBasedPrivateKeySourceImpl
implements KeySource {
    private KeyStore keyStore;
    private ReadKeyPassword readKeyPassword;

    public KeyStoreBasedPrivateKeySourceImpl(KeyStore keyStore, ReadKeyPassword readKeyPassword) {
        this.keyStore = keyStore;
        this.readKeyPassword = readKeyPassword;
    }

    @Override
    public Key readKey(KeyID keyID) {
        try {
            return this.keyStore.getKey(keyID.getValue(), this.readKeyPassword.getValue().toCharArray());
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }
}

