/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.service.api;

import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.PasswordLookup;
import com.nimbusds.jose.jwk.RSAKey;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.encobject.domain.KeyStoreAccess;
import org.adorsys.encobject.exceptions.AsymmetricEncryptionException;
import org.adorsys.encobject.exceptions.SymmetricEncryptionException;
import org.adorsys.encobject.service.api.KeySource;
import org.adorsys.encobject.service.api.KeystorePersistence;
import org.adorsys.encobject.service.impl.KeyStoreBasedPrivateKeySourceImpl;
import org.adorsys.encobject.service.impl.KeyStoreBasedPublicKeySourceImpl;
import org.adorsys.encobject.service.impl.KeyStoreBasedSecretKeySourceImpl;
import org.adorsys.encobject.types.KeyID;
import org.adorsys.jjwk.keystore.JwkExport;
import org.adorsys.jjwk.serverkey.KeyAndJwk;
import org.adorsys.jjwk.serverkey.ServerKeyMap;
import org.adorsys.jkeygen.utils.V3CertificateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStore2KeySourceHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyStore2KeySourceHelper.class);

    public static KeySourceAndKeyID getForPublicKey(KeystorePersistence keystorePersistence, KeyStoreAccess keyStoreAccess) {
        LOGGER.debug("get keysource for public key of " + keyStoreAccess.getKeyStorePath());
        KeyStore userKeystore = keystorePersistence.loadKeystore(keyStoreAccess.getKeyStorePath().getObjectHandle(), keyStoreAccess.getKeyStoreAuth().getReadStoreHandler());
        JWKSet exportKeys = KeyStore2KeySourceHelper.load(userKeystore, null);
        LOGGER.debug("number of public keys found:" + exportKeys.getKeys().size());
        List<JWK> encKeys = KeyStore2KeySourceHelper.selectEncKeys(exportKeys);
        if (encKeys.isEmpty()) {
            throw new AsymmetricEncryptionException("did not find any public keys in keystore " + keyStoreAccess.getKeyStorePath());
        }
        JWK randomKey = JwkExport.randomKey(encKeys);
        KeyID keyID = new KeyID(randomKey.getKeyID());
        KeyStoreBasedPublicKeySourceImpl keySource = new KeyStoreBasedPublicKeySourceImpl(exportKeys);
        return new KeySourceAndKeyID(keySource, keyID);
    }

    public static JWK getForPublicKeyJWK(KeystorePersistence keystorePersistence, KeyStoreAccess keyStoreAccess) {
        LOGGER.debug("get keysource for public key of " + keyStoreAccess.getKeyStorePath());
        KeyStore userKeystore = keystorePersistence.loadKeystore(keyStoreAccess.getKeyStorePath().getObjectHandle(), keyStoreAccess.getKeyStoreAuth().getReadStoreHandler());
        JWKSet exportKeys = KeyStore2KeySourceHelper.load(userKeystore, null);
        LOGGER.debug("number of public keys found:" + exportKeys.getKeys().size());
        List<JWK> encKeys = KeyStore2KeySourceHelper.selectEncKeys(exportKeys);
        if (encKeys.isEmpty()) {
            throw new AsymmetricEncryptionException("did not find any public keys in keystore " + keyStoreAccess.getKeyStorePath());
        }
        return JwkExport.randomKey(encKeys);
    }

    public static KeySource getForPrivateKey(KeystorePersistence keystorePersistence, KeyStoreAccess keyStoreAccess) {
        LOGGER.debug("get keysource for private key of " + keyStoreAccess.getKeyStorePath());
        KeyStore userKeystore = keystorePersistence.loadKeystore(keyStoreAccess.getKeyStorePath().getObjectHandle(), keyStoreAccess.getKeyStoreAuth().getReadStoreHandler());
        KeyStoreBasedPrivateKeySourceImpl keySource = new KeyStoreBasedPrivateKeySourceImpl(userKeystore, keyStoreAccess.getKeyStoreAuth().getReadKeyPassword());
        return keySource;
    }

    public static KeySourceAndKeyID getForSecretKey(KeystorePersistence keystorePersistence, KeyStoreAccess keyStoreAccess) {
        LOGGER.debug("get keysource for secret key of " + keyStoreAccess.getKeyStorePath());
        KeyStore userKeystore = keystorePersistence.loadKeystore(keyStoreAccess.getKeyStorePath().getObjectHandle(), keyStoreAccess.getKeyStoreAuth().getReadStoreHandler());
        KeyStoreBasedSecretKeySourceImpl keySource = new KeyStoreBasedSecretKeySourceImpl(userKeystore, keyStoreAccess.getKeyStoreAuth().getReadKeyHandler());
        JWKSet jwkSet = JwkExport.exportKeys((KeyStore)userKeystore, (CallbackHandler)keyStoreAccess.getKeyStoreAuth().getReadKeyHandler());
        if (jwkSet.getKeys().isEmpty()) {
            throw new SymmetricEncryptionException("did not find any secret keys in keystore with id: " + keyStoreAccess.getKeyStorePath());
        }
        ServerKeyMap serverKeyMap = new ServerKeyMap(jwkSet);
        KeyAndJwk randomSecretKey = serverKeyMap.randomSecretKey();
        KeyID keyID = new KeyID(randomSecretKey.jwk.getKeyID());
        return new KeySourceAndKeyID(keySource, keyID);
    }

    private static List<JWK> selectEncKeys(JWKSet exportKeys) {
        JWKMatcher signKeys = new JWKMatcher.Builder().keyUse(KeyUse.ENCRYPTION).build();
        return new JWKSelector(signKeys).select(exportKeys);
    }

    private static JWKSet load(KeyStore keyStore, PasswordLookup pwLookup) {
        try {
            LinkedList<Object> jwks = new LinkedList<Object>();
            Enumeration<String> keyAliases = keyStore.aliases();
            while (keyAliases.hasMoreElements()) {
                List convertedCert;
                String keyAlias = keyAliases.nextElement();
                char[] keyPassword = pwLookup == null ? "".toCharArray() : pwLookup.lookupPassword(keyAlias);
                Certificate cert = keyStore.getCertificate(keyAlias);
                if (cert == null) continue;
                Certificate[] certs = new Certificate[]{cert};
                if (cert.getPublicKey() instanceof RSAPublicKey) {
                    convertedCert = V3CertificateUtils.convert((Certificate[])certs);
                    RSAKey rsaJWK = RSAKey.parse((X509Certificate)((X509Certificate)convertedCert.get(0)));
                    rsaJWK = new RSAKey.Builder(rsaJWK).keyID(keyAlias).keyStore(keyStore).build();
                    jwks.add(rsaJWK);
                    continue;
                }
                if (!(cert.getPublicKey() instanceof ECPublicKey)) continue;
                convertedCert = V3CertificateUtils.convert((Certificate[])certs);
                ECKey ecJWK = ECKey.parse((X509Certificate)((X509Certificate)convertedCert.get(0)));
                ecJWK = new ECKey.Builder(ecJWK).keyID(keyAlias).keyStore(keyStore).build();
                jwks.add(ecJWK);
            }
            return new JWKSet(jwks);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public static class KeySourceAndKeyID {
        private final KeySource keySource;
        private final KeyID keyID;

        public KeySourceAndKeyID(KeySource keySource, KeyID keyID) {
            this.keySource = keySource;
            this.keyID = keyID;
        }

        public KeySource getKeySource() {
            return this.keySource;
        }

        public KeyID getKeyID() {
            return this.keyID;
        }
    }
}

