/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.service.impl;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.encobject.domain.KeyCredentials;
import org.adorsys.encobject.exceptions.WrongKeyCredentialException;
import org.adorsys.encobject.service.api.KeySource;
import org.adorsys.encobject.service.api.KeystorePersistence;
import org.adorsys.encobject.types.KeyID;
import org.adorsys.jkeygen.keystore.PasswordCallbackUtils;
import org.adorsys.jkeygen.pwd.PasswordCallbackHandler;

public class KeyCredentialBasedKeySourceImpl
implements KeySource {
    private KeyCredentials keyCredentials;
    private KeyStore keyStore;
    private KeystorePersistence keystorePersistence;

    public KeyCredentialBasedKeySourceImpl(KeyCredentials keyCredentials, KeystorePersistence keystorePersistence) {
        this.keyCredentials = keyCredentials;
        this.keystorePersistence = keystorePersistence;
    }

    @Override
    public Key readKey(KeyID keyID) {
        if (this.keyStore == null) {
            this.keyStore = this.keystorePersistence.loadKeystore(this.keyCredentials.getHandle(), (CallbackHandler)new PasswordCallbackHandler(this.keyCredentials.getStorepass().toCharArray()));
        }
        try {
            return this.keyStore.getKey(keyID.getValue(), PasswordCallbackUtils.getPassword((CallbackHandler)new PasswordCallbackHandler(this.keyCredentials.getKeypass().toCharArray()), (String)keyID.getValue()));
        }
        catch (UnrecoverableKeyException e) {
            throw new WrongKeyCredentialException(e);
        }
        catch (KeyStoreException e) {
            throw new WrongKeyCredentialException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

