/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.service.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.encobject.complextypes.BucketPath;
import org.adorsys.encobject.domain.Payload;
import org.adorsys.encobject.domain.PayloadStream;
import org.adorsys.encobject.service.api.EncryptedPersistenceService;
import org.adorsys.encobject.service.api.EncryptionStreamService;
import org.adorsys.encobject.service.api.ExtendedStoreConnection;
import org.adorsys.encobject.service.api.KeySource;
import org.adorsys.encobject.service.impl.SimplePayloadImpl;
import org.adorsys.encobject.service.impl.SimplePayloadStreamImpl;
import org.adorsys.encobject.types.KeyID;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedPersistenceServiceImpl
implements EncryptedPersistenceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptedPersistenceServiceImpl.class);
    private static final String ENCRYPTION_SERVICE = "EncryptedPersistenceServiceImpl.ENCRYPTION_SERVICE";
    private static final String ENCRYPTION_KEY_ID = "EncryptedPersistenceServiceImpl.ENCRYPTION_KEY_ID";
    ExtendedStoreConnection extendedStoreConnection;
    EncryptionStreamService encryptionStreamService;

    public EncryptedPersistenceServiceImpl(ExtendedStoreConnection extendedStoreConnection, EncryptionStreamService encryptionStreamService) {
        this.extendedStoreConnection = extendedStoreConnection;
        this.encryptionStreamService = encryptionStreamService;
    }

    @Override
    public void encryptAndPersist(BucketPath bucketPath, Payload payload, KeySource keySource, KeyID keyID) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(payload.getData());
        InputStream encryptedInputStream = this.encryptionStreamService.getEncryptedInputStream(inputStream, keySource, keyID, payload.getStorageMetadata().getShouldBeCompressed());
        payload.getStorageMetadata().getUserMetadata().put(ENCRYPTION_SERVICE, this.encryptionStreamService.getClass().toString());
        payload.getStorageMetadata().getUserMetadata().put(ENCRYPTION_KEY_ID, keyID.getValue());
        LOGGER.debug("ENCRYPT BYTES WITH " + (Object)((Object)keyID));
        SimplePayloadStreamImpl newPayload = new SimplePayloadStreamImpl(payload.getStorageMetadata(), encryptedInputStream);
        this.extendedStoreConnection.putBlobStream(bucketPath, (PayloadStream)newPayload);
    }

    @Override
    public Payload loadAndDecrypt(BucketPath bucketPath, KeySource keySource) {
        try {
            Payload payload = this.extendedStoreConnection.getBlob(bucketPath);
            String encryptionType = payload.getStorageMetadata().getUserMetadata().get(ENCRYPTION_SERVICE);
            payload.getStorageMetadata().getUserMetadata().remove(ENCRYPTION_SERVICE);
            if (!encryptionType.equals(this.encryptionStreamService.getClass().toString())) {
                throw new BaseException("expected encryptionService of class " + encryptionType + " but was " + this.encryptionStreamService.getClass().toString());
            }
            String keyIDString = payload.getStorageMetadata().getUserMetadata().get(ENCRYPTION_KEY_ID);
            payload.getStorageMetadata().getUserMetadata().remove(ENCRYPTION_KEY_ID);
            KeyID keyID = new KeyID(keyIDString);
            LOGGER.debug("DECRYPT BYTES WITH " + (Object)((Object)keyID));
            ByteArrayInputStream encryptedInputStream = new ByteArrayInputStream(payload.getData());
            InputStream decryptedInputStream = this.encryptionStreamService.getDecryptedInputStream(encryptedInputStream, keySource, keyID);
            byte[] decryptData = IOUtils.toByteArray((InputStream)decryptedInputStream);
            return new SimplePayloadImpl(payload.getStorageMetadata(), decryptData);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public void encryptAndPersistStream(BucketPath bucketPath, PayloadStream payloadStream, KeySource keySource, KeyID keyID) {
        payloadStream.getStorageMetadata().getUserMetadata().put(ENCRYPTION_SERVICE, this.encryptionStreamService.getClass().toString());
        payloadStream.getStorageMetadata().getUserMetadata().put(ENCRYPTION_KEY_ID, keyID.getValue());
        LOGGER.debug("ENCRYPT STREAM WITH " + (Object)((Object)keyID));
        InputStream encryptedStream = this.encryptionStreamService.getEncryptedInputStream(payloadStream.openStream(), keySource, keyID, payloadStream.getStorageMetadata().getShouldBeCompressed());
        this.extendedStoreConnection.putBlobStream(bucketPath, (PayloadStream)new SimplePayloadStreamImpl(payloadStream.getStorageMetadata(), encryptedStream));
    }

    @Override
    public PayloadStream loadAndDecryptStream(BucketPath bucketPath, KeySource keySource) {
        PayloadStream payloadStream = this.extendedStoreConnection.getBlobStream(bucketPath);
        String encryptionType = payloadStream.getStorageMetadata().getUserMetadata().get(ENCRYPTION_SERVICE);
        payloadStream.getStorageMetadata().getUserMetadata().remove(ENCRYPTION_SERVICE);
        if (!encryptionType.equals(this.encryptionStreamService.getClass().toString())) {
            throw new BaseException("expected encryptionService of class " + encryptionType + " but was " + this.encryptionStreamService.getClass().toString());
        }
        String keyIDString = payloadStream.getStorageMetadata().getUserMetadata().get(ENCRYPTION_KEY_ID);
        payloadStream.getStorageMetadata().getUserMetadata().remove(ENCRYPTION_KEY_ID);
        KeyID keyID = new KeyID(keyIDString);
        LOGGER.debug("DECRYPT STREAM WITH " + (Object)((Object)keyID));
        InputStream encryptedInputStream = payloadStream.openStream();
        InputStream decryptedInputStream = this.encryptionStreamService.getDecryptedInputStream(encryptedInputStream, keySource, keyID);
        return new SimplePayloadStreamImpl(payloadStream.getStorageMetadata(), decryptedInputStream);
    }
}

