/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.userdata;

import java.security.KeyStore;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.encobject.complextypes.BucketDirectory;
import org.adorsys.encobject.complextypes.BucketPath;
import org.adorsys.encobject.domain.KeyCredentials;
import org.adorsys.encobject.domain.ObjectHandle;
import org.adorsys.encobject.domain.Payload;
import org.adorsys.encobject.exceptions.ObjectNotFoundException;
import org.adorsys.encobject.params.KeyParams;
import org.adorsys.encobject.service.api.EncryptedPersistenceService;
import org.adorsys.encobject.service.api.EncryptionStreamService;
import org.adorsys.encobject.service.api.ExtendedStoreConnection;
import org.adorsys.encobject.service.api.KeystorePersistence;
import org.adorsys.encobject.service.impl.BlobStoreKeystorePersistenceImpl;
import org.adorsys.encobject.service.impl.EncryptedPersistenceServiceImpl;
import org.adorsys.encobject.service.impl.KeyCredentialBasedKeySourceImpl;
import org.adorsys.encobject.service.impl.SimplePayloadImpl;
import org.adorsys.encobject.types.KeyID;
import org.adorsys.encobject.userdata.ObjectMapperSPI;
import org.adorsys.jkeygen.keystore.KeyStoreService;
import org.adorsys.jkeygen.keystore.SecretKeyData;
import org.adorsys.jkeygen.keystore.SecretKeyEntry;
import org.adorsys.jkeygen.pwd.PasswordCallbackHandler;
import org.adorsys.jkeygen.secretkey.SecretKeyBuilder;

public class ObjectPersistenceAdapter {
    private ObjectMapperSPI objectMapper;
    private KeyCredentials keyCredentials;
    private EncryptedPersistenceService encObjectService;
    private ExtendedStoreConnection storeConnection;
    private KeystorePersistence keystorePersistence;
    private KeyCredentialBasedKeySourceImpl keySource;

    public ObjectPersistenceAdapter(EncryptionStreamService encryptionService, ExtendedStoreConnection storeConnection, KeyCredentials keyCredentials, ObjectMapperSPI objectMapper) {
        this.keyCredentials = keyCredentials;
        this.keySource = new KeyCredentialBasedKeySourceImpl(keyCredentials, this.keystorePersistence);
        this.objectMapper = objectMapper;
        this.storeConnection = storeConnection;
        this.keystorePersistence = new BlobStoreKeystorePersistenceImpl(storeConnection);
        this.encObjectService = new EncryptedPersistenceServiceImpl(storeConnection, encryptionService);
    }

    public boolean hasStore() {
        return this.keystorePersistence.hasKeystore(this.keyCredentials.getHandle());
    }

    public void initStore() {
        try {
            BucketDirectory container = new BucketDirectory(this.keyCredentials.getHandle().getContainer());
            if (!this.storeConnection.containerExists(container)) {
                this.storeConnection.createContainer(container);
            }
            this.newSecretKey(this.keyCredentials, ObjectPersistenceAdapter.keyParams());
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public <T> T load(ObjectHandle handle, Class<T> klass) {
        try {
            Payload payload = this.encObjectService.loadAndDecrypt(BucketPath.fromHandle((ObjectHandle)handle), this.keySource);
            return this.objectMapper.readValue(payload.getData(), klass);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public <T> void store(ObjectHandle userMainRecordhandle, T t) {
        this.storeInternal(userMainRecordhandle, t);
    }

    private <T> void storeInternal(ObjectHandle handle, T t) {
        BucketDirectory container = new BucketDirectory(this.keyCredentials.getHandle().getContainer());
        if (!this.storeConnection.containerExists(container)) {
            this.storeConnection.createContainer(container);
        }
        try {
            byte[] data = this.objectMapper.writeValueAsBytes(t);
            this.encObjectService.encryptAndPersist(BucketPath.fromHandle((ObjectHandle)handle), (Payload)new SimplePayloadImpl(data), this.keySource, new KeyID(this.keyCredentials.getKeyid()));
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public KeyCredentials getKeyCredentials() {
        return this.keyCredentials;
    }

    private static KeyParams keyParams() {
        KeyParams keyParams = new KeyParams();
        keyParams.setKeyAlogirithm("AES");
        keyParams.setKeyLength(256);
        return keyParams;
    }

    public void newSecretKey(KeyCredentials keyCredentials, KeyParams keyParams) {
        KeyStore keyStore;
        PasswordCallbackHandler storePassHandler = new PasswordCallbackHandler(keyCredentials.getStorepass().toCharArray());
        PasswordCallbackHandler secretKeyPassHandler = new PasswordCallbackHandler(keyCredentials.getKeypass().toCharArray());
        SecretKey secretKey = new SecretKeyBuilder().withKeyAlg(keyParams.getKeyAlogirithm()).withKeyLength(Integer.valueOf(keyParams.getKeyLength())).build();
        SecretKeyData secretKeyData = SecretKeyData.builder().secretKey(secretKey).alias(keyCredentials.getKeyid()).passwordSource((CallbackHandler)secretKeyPassHandler).build();
        try {
            keyStore = this.keystorePersistence.loadKeystore(keyCredentials.getHandle(), (CallbackHandler)storePassHandler);
        }
        catch (ObjectNotFoundException e) {
            keyStore = KeyStoreService.newKeyStore(null);
        }
        KeyStoreService.addToKeyStore((KeyStore)keyStore, (SecretKeyEntry)secretKeyData);
        this.keystorePersistence.saveKeyStore(keyStore, (CallbackHandler)storePassHandler, keyCredentials.getHandle());
    }
}

