/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.service.impl.generator;

import java.security.KeyStore;
import java.util.UUID;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.encobject.domain.ReadKeyPassword;
import org.adorsys.encobject.service.api.generator.KeyPairGenerator;
import org.adorsys.encobject.service.api.generator.KeyStoreCreationConfig;
import org.adorsys.encobject.service.api.generator.SecretKeyGenerator;
import org.adorsys.jkeygen.keystore.KeyEntry;
import org.adorsys.jkeygen.keystore.KeyPairData;
import org.adorsys.jkeygen.keystore.KeyStoreType;
import org.adorsys.jkeygen.keystore.KeystoreBuilder;
import org.adorsys.jkeygen.keystore.SecretKeyData;
import org.adorsys.jkeygen.pwd.PasswordCallbackHandler;
import org.apache.commons.lang3.RandomStringUtils;

public class KeyStoreGenerator {
    private final KeyStoreType keyStoreType;
    private final String serverKeyPairAliasPrefix;
    private final CallbackHandler readKeyHandler;
    private final KeyStoreCreationConfig config;

    public KeyStoreGenerator(KeyStoreCreationConfig config, KeyStoreType keyStoreType, String serverKeyPairAliasPrefix, ReadKeyPassword readKeyPassword) {
        this.config = config;
        this.keyStoreType = keyStoreType;
        this.serverKeyPairAliasPrefix = serverKeyPairAliasPrefix;
        this.readKeyHandler = new PasswordCallbackHandler(readKeyPassword.getValue().toCharArray());
    }

    public KeyStore generate() {
        String keyStoreID = this.serverKeyPairAliasPrefix;
        try {
            KeyPairData signatureKeyPair;
            int i;
            KeystoreBuilder keystoreBuilder = new KeystoreBuilder().withStoreType(this.keyStoreType);
            PasswordCallbackHandler dummyKeyHandler = new PasswordCallbackHandler("".toCharArray());
            KeyPairGenerator encKeyPairGenerator = this.config.getEncKeyPairGenerator(keyStoreID);
            int numberOfEncKeyPairs = this.config.getEncKeyNumber();
            for (i = 0; i < numberOfEncKeyPairs; ++i) {
                signatureKeyPair = encKeyPairGenerator.generateEncryptionKey(this.serverKeyPairAliasPrefix + RandomStringUtils.randomAlphanumeric((int)5).toUpperCase(), this.readKeyHandler);
                keystoreBuilder = keystoreBuilder.withKeyEntry((KeyEntry)signatureKeyPair);
            }
            KeyPairGenerator signKeyPairGenerator = this.config.getSignKeyPairGenerator(keyStoreID);
            int numberOfSignKeyPairs = this.config.getSignKeyNumber();
            for (i = 0; i < numberOfSignKeyPairs; ++i) {
                signatureKeyPair = signKeyPairGenerator.generateSignatureKey(this.serverKeyPairAliasPrefix + UUID.randomUUID().toString(), this.readKeyHandler);
                keystoreBuilder = keystoreBuilder.withKeyEntry((KeyEntry)signatureKeyPair);
            }
            SecretKeyGenerator secretKeyGenerator = this.config.getSecretKeyGenerator(keyStoreID);
            int numberOfSecretKeys = this.config.getSecretKeyNumber();
            for (i = 0; i < numberOfSecretKeys; ++i) {
                SecretKeyData secretKeyData = secretKeyGenerator.generate(this.serverKeyPairAliasPrefix + RandomStringUtils.randomAlphanumeric((int)5).toUpperCase(), this.readKeyHandler);
                keystoreBuilder = keystoreBuilder.withKeyEntry((KeyEntry)secretKeyData);
            }
            return keystoreBuilder.build();
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }
}

