/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.service;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.encobject.domain.ObjectHandle;
import org.adorsys.encobject.domain.Tuple;
import org.adorsys.encobject.domain.keystore.KeystoreData;
import org.adorsys.encobject.service.BlobStoreConnection;
import org.adorsys.encobject.service.BlobStoreContextFactory;
import org.adorsys.encobject.service.KeystoreNotFoundException;
import org.adorsys.encobject.service.KeystorePersistence;
import org.adorsys.encobject.service.MissingKeyAlgorithmException;
import org.adorsys.encobject.service.MissingKeystoreAlgorithmException;
import org.adorsys.encobject.service.MissingKeystoreProviderException;
import org.adorsys.encobject.service.ObjectNotFoundException;
import org.adorsys.encobject.service.UnknownContainerException;
import org.adorsys.encobject.service.WrongKeystoreCredentialException;
import org.adorsys.jkeygen.keystore.KeyStoreService;

public class BlobStoreKeystorePersistence
implements KeystorePersistence {
    private BlobStoreConnection blobStoreConnection;

    public BlobStoreKeystorePersistence(BlobStoreContextFactory blobStoreContextFactory) {
        this.blobStoreConnection = new BlobStoreConnection(blobStoreContextFactory);
    }

    public void saveKeyStore(KeyStore keystore, CallbackHandler storePassHandler, ObjectHandle handle) throws NoSuchAlgorithmException, CertificateException, UnknownContainerException {
        try {
            String storeType = keystore.getType();
            byte[] bs = KeyStoreService.toByteArray((KeyStore)keystore, (String)handle.getName(), (CallbackHandler)storePassHandler);
            KeystoreData keystoreData = KeystoreData.newBuilder().setType(storeType).setKeystore(ByteString.copyFrom((byte[])bs)).build();
            this.blobStoreConnection.putBlob(handle, keystoreData.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void saveKeyStoreWithAttributes(KeyStore keystore, Map<String, String> attributes, CallbackHandler storePassHandler, ObjectHandle handle) throws NoSuchAlgorithmException, CertificateException, UnknownContainerException {
        try {
            String storeType = keystore.getType();
            byte[] bs = KeyStoreService.toByteArray((KeyStore)keystore, (String)handle.getName(), (CallbackHandler)storePassHandler);
            KeystoreData keystoreData = KeystoreData.newBuilder().setType(storeType).setKeystore(ByteString.copyFrom((byte[])bs)).putAllAttributes(attributes).build();
            this.blobStoreConnection.putBlob(handle, keystoreData.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public KeyStore loadKeystore(ObjectHandle handle, CallbackHandler handler) throws KeystoreNotFoundException, CertificateException, WrongKeystoreCredentialException, MissingKeystoreAlgorithmException, MissingKeystoreProviderException, MissingKeyAlgorithmException, IOException, UnknownContainerException {
        KeystoreData keystoreData = this.loadKeystoreData(handle);
        return this.initKeystore(keystoreData, handle.getName(), handler);
    }

    public Tuple<KeyStore, Map<String, String>> loadKeystoreAndAttributes(ObjectHandle handle, CallbackHandler handler) throws KeystoreNotFoundException, CertificateException, WrongKeystoreCredentialException, MissingKeystoreAlgorithmException, MissingKeystoreProviderException, MissingKeyAlgorithmException, IOException, UnknownContainerException {
        KeystoreData keystoreData = this.loadKeystoreData(handle);
        KeyStore keyStore = this.initKeystore(keystoreData, handle.getName(), handler);
        return new Tuple((Object)keyStore, (Object)keystoreData.getAttributesMap());
    }

    public boolean hasKeystore(ObjectHandle handle) {
        try {
            return this.blobStoreConnection.getBlob(handle) != null;
        }
        catch (ObjectNotFoundException | UnknownContainerException e) {
            return false;
        }
    }

    private KeystoreData loadKeystoreData(ObjectHandle handle) throws KeystoreNotFoundException, UnknownContainerException {
        byte[] keyStoreBytes;
        try {
            keyStoreBytes = this.blobStoreConnection.getBlob(handle);
        }
        catch (ObjectNotFoundException e) {
            throw new KeystoreNotFoundException(e.getMessage(), (Throwable)e);
        }
        try {
            return KeystoreData.parseFrom((byte[])keyStoreBytes);
        }
        catch (IOException e) {
            throw new IllegalStateException("Invalid protocol buffer", e);
        }
    }

    private KeyStore initKeystore(KeystoreData keystoreData, String storeid, CallbackHandler handler) throws WrongKeystoreCredentialException, MissingKeystoreAlgorithmException, MissingKeystoreProviderException, MissingKeyAlgorithmException, CertificateException, IOException {
        try {
            return KeyStoreService.loadKeyStore((byte[])keystoreData.getKeystore().toByteArray(), (String)storeid, (String)keystoreData.getType(), (CallbackHandler)handler);
        }
        catch (UnrecoverableKeyException e) {
            throw new WrongKeystoreCredentialException((Throwable)e);
        }
        catch (KeyStoreException e) {
            if (e.getCause() != null) {
                Throwable cause = e.getCause();
                if (cause instanceof NoSuchAlgorithmException) {
                    throw new MissingKeystoreAlgorithmException(cause.getMessage(), cause);
                }
                if (cause instanceof NoSuchProviderException) {
                    throw new MissingKeystoreProviderException(cause.getMessage(), cause);
                }
            }
            throw new IllegalStateException("Unidentified keystore exception", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new MissingKeyAlgorithmException(e.getMessage(), (Throwable)e);
        }
    }
}

