/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.adorsys.encobject.domain.ObjectHandle;
import org.adorsys.encobject.domain.Tuple;
import org.adorsys.encobject.service.BlobStoreContextFactory;
import org.adorsys.encobject.service.ContainerExistsException;
import org.adorsys.encobject.service.ObjectNotFoundException;
import org.adorsys.encobject.service.StoreConnection;
import org.adorsys.encobject.service.UnknownContainerException;
import org.apache.commons.io.IOUtils;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.domain.Blob;

public class BlobStoreConnection
implements StoreConnection {
    private BlobStoreContextFactory blobStoreContextFactory;

    public BlobStoreConnection(BlobStoreContextFactory blobStoreContextFactory) {
        this.blobStoreContextFactory = blobStoreContextFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createContainer(String container) throws ContainerExistsException {
        BlobStoreContext blobStoreContext = this.blobStoreContextFactory.alocate();
        try {
            BlobStore blobStore = blobStoreContext.getBlobStore();
            if (blobStore.containerExists(container)) {
                throw new ContainerExistsException(container);
            }
            blobStoreContext.getBlobStore().createContainerInLocation(null, container);
        }
        finally {
            this.blobStoreContextFactory.dispose(blobStoreContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containerExists(String container) {
        BlobStoreContext blobStoreContext = this.blobStoreContextFactory.alocate();
        try {
            BlobStore blobStore = blobStoreContext.getBlobStore();
            boolean bl = blobStore.containerExists(container);
            return bl;
        }
        finally {
            this.blobStoreContextFactory.dispose(blobStoreContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteContainer(String container) throws UnknownContainerException {
        BlobStoreContext blobStoreContext = this.blobStoreContextFactory.alocate();
        try {
            BlobStore blobStore = blobStoreContext.getBlobStore();
            if (!blobStore.containerExists(container)) {
                throw new UnknownContainerException(container);
            }
            blobStoreContext.getBlobStore().deleteContainer(container);
        }
        finally {
            this.blobStoreContextFactory.dispose(blobStoreContext);
        }
    }

    public void putBlob(ObjectHandle handle, byte[] bytes) throws UnknownContainerException {
        BlobStoreContext blobStoreContext = this.blobStoreContextFactory.alocate();
        try {
            BlobStore blobStore = blobStoreContext.getBlobStore();
            Blob blob = blobStore.blobBuilder(handle.getName()).payload(bytes).build();
            blobStore.putBlob(handle.getContainer(), blob);
        }
        catch (ContainerNotFoundException ex) {
            throw new UnknownContainerException(handle.getContainer());
        }
        finally {
            this.blobStoreContextFactory.dispose(blobStoreContext);
        }
    }

    public void putBlobWithMetadata(ObjectHandle handle, byte[] bytes, Map<String, String> userMetadata) throws UnknownContainerException {
        BlobStoreContext blobStoreContext = this.blobStoreContextFactory.alocate();
        try {
            BlobStore blobStore = blobStoreContext.getBlobStore();
            Blob blob = blobStore.blobBuilder(handle.getName()).payload(bytes).userMetadata(userMetadata).build();
            blobStore.putBlob(handle.getContainer(), blob);
        }
        catch (ContainerNotFoundException ex) {
            throw new UnknownContainerException(handle.getContainer());
        }
        finally {
            this.blobStoreContextFactory.dispose(blobStoreContext);
        }
    }

    public byte[] getBlob(ObjectHandle handle) throws UnknownContainerException, ObjectNotFoundException {
        BlobStoreContext blobStoreContext = this.blobStoreContextFactory.alocate();
        try {
            Blob blob;
            BlobStore blobStore = blobStoreContext.getBlobStore();
            try {
                blob = blobStore.getBlob(handle.getContainer(), handle.getName());
                if (blob == null) {
                    throw new ObjectNotFoundException(handle.getContainer() + "/" + handle.getName());
                }
            }
            catch (ContainerNotFoundException e) {
                throw new UnknownContainerException(handle.getContainer());
            }
            try {
                byte[] e = IOUtils.toByteArray((InputStream)blob.getPayload().openStream());
                return e;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        finally {
            this.blobStoreContextFactory.dispose(blobStoreContext);
        }
    }

    public Tuple<byte[], Map<String, String>> getBlobAndMetadata(ObjectHandle handle) throws UnknownContainerException, ObjectNotFoundException {
        BlobStoreContext blobStoreContext = this.blobStoreContextFactory.alocate();
        try {
            Blob blob;
            BlobStore blobStore = blobStoreContext.getBlobStore();
            try {
                blob = blobStore.getBlob(handle.getContainer(), handle.getName());
                if (blob == null) {
                    throw new ObjectNotFoundException(handle.getContainer() + "/" + handle.getName());
                }
            }
            catch (ContainerNotFoundException e) {
                throw new UnknownContainerException(handle.getContainer());
            }
            try {
                byte[] bytes = IOUtils.toByteArray((InputStream)blob.getPayload().openStream());
                Map userMetadata = blob.getMetadata().getUserMetadata();
                Tuple tuple = new Tuple((Object)bytes, (Object)userMetadata);
                return tuple;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        finally {
            this.blobStoreContextFactory.dispose(blobStoreContext);
        }
    }
}

