/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.serverdata;

import com.nimbusds.jose.CompressionAlgorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.factories.DefaultJWEDecrypterFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.adorsys.encobject.domain.ContentMetaInfo;
import org.adorsys.encobject.domain.ObjectHandle;
import org.adorsys.encobject.params.EncParamSelector;
import org.adorsys.encobject.params.EncryptionParams;
import org.adorsys.encobject.service.ObjectNotFoundException;
import org.adorsys.encobject.service.StoreConnection;
import org.adorsys.encobject.service.UnknownContainerException;
import org.adorsys.encobject.service.WrongKeyCredentialException;
import org.adorsys.jjwk.selector.JWEEncryptedSelector;
import org.adorsys.jjwk.selector.UnsupportedEncAlgorithmException;
import org.adorsys.jjwk.selector.UnsupportedKeyLengthException;
import org.adorsys.jjwk.serverkey.ServerKeyMapProvider;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ServerObjectPersistence {
    private DefaultJWEDecrypterFactory decrypterFactory = new DefaultJWEDecrypterFactory();
    private StoreConnection blobStoreConnection;

    public ServerObjectPersistence(StoreConnection storeConnection) {
        this.blobStoreConnection = storeConnection;
    }

    public void storeObject(byte[] data, ContentMetaInfo metaInfo, ObjectHandle handle, ServerKeyMapProvider keyMapProvider, String keyID, EncryptionParams encParams) throws UnsupportedEncAlgorithmException, UnsupportedKeyLengthException, UnknownContainerException {
        byte[] bytesToStore;
        String zip;
        if (metaInfo == null) {
            metaInfo = new ContentMetaInfo();
        }
        Key key = keyMapProvider.getKey(keyID);
        if (encParams == null) {
            encParams = EncParamSelector.selectEncryptionParams((Key)key);
        }
        JWEHeader.Builder headerBuilder = new JWEHeader.Builder(encParams.getEncAlgo(), encParams.getEncMethod()).keyID(keyID);
        String contentTrype = metaInfo.getContentTrype();
        if (StringUtils.isNotBlank((CharSequence)contentTrype)) {
            headerBuilder = headerBuilder.contentType(contentTrype);
        }
        if (StringUtils.isNotBlank((CharSequence)(zip = metaInfo.getZip()))) {
            headerBuilder = headerBuilder.compressionAlgorithm(CompressionAlgorithm.DEF);
        } else if (StringUtils.isNotBlank((CharSequence)contentTrype) && StringUtils.containsIgnoreCase((CharSequence)contentTrype, (CharSequence)"text")) {
            headerBuilder = headerBuilder.compressionAlgorithm(CompressionAlgorithm.DEF);
        }
        HashMap<String, Long> addInfos = metaInfo.getAddInfos();
        if (metaInfo.getExp() != null) {
            if (addInfos == null) {
                addInfos = new HashMap<String, Long>();
            }
            addInfos.put("exp", metaInfo.getExp().getTime());
        }
        if (addInfos != null) {
            headerBuilder = headerBuilder.customParams((Map)addInfos);
        }
        JWEHeader header = headerBuilder.build();
        JWEEncrypter jweEncrypter = JWEEncryptedSelector.geEncrypter((Key)key, (JWEAlgorithm)encParams.getEncAlgo(), (EncryptionMethod)encParams.getEncMethod());
        JWEObject jweObject = new JWEObject(header, new Payload(data));
        try {
            jweObject.encrypt(jweEncrypter);
        }
        catch (JOSEException e) {
            throw new IllegalStateException("Encryption error", e);
        }
        String jweEncryptedObject = jweObject.serialize();
        try {
            bytesToStore = jweEncryptedObject.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unsupported content type", e);
        }
        this.blobStoreConnection.putBlob(handle, bytesToStore);
    }

    public byte[] loadObject(ObjectHandle handle, ServerKeyMapProvider keyMapProvider) throws UnknownContainerException, ObjectNotFoundException, WrongKeyCredentialException {
        JWEDecrypter decrypter;
        JWEObject jweObject;
        String jweEncryptedObject;
        byte[] jweEncryptedBytes = this.blobStoreConnection.getBlob(handle);
        try {
            jweEncryptedObject = IOUtils.toString((byte[])jweEncryptedBytes, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new IllegalStateException("Unsupported content type", e);
        }
        try {
            jweObject = JWEObject.parse((String)jweEncryptedObject);
        }
        catch (ParseException e) {
            throw new IllegalStateException("Can not parse jwe object", e);
        }
        String keyID = jweObject.getHeader().getKeyID();
        Key key = keyMapProvider.getKey(keyID);
        try {
            decrypter = this.decrypterFactory.createJWEDecrypter(jweObject.getHeader(), key);
        }
        catch (JOSEException e) {
            throw new IllegalStateException("No suitable key found", e);
        }
        try {
            jweObject.decrypt(decrypter);
        }
        catch (JOSEException e) {
            throw new WrongKeyCredentialException((Throwable)e);
        }
        return jweObject.getPayload().toBytes();
    }
}

