/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.serverdata;

import com.nimbusds.jose.jwk.JWKSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.UUID;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.encobject.domain.ObjectHandle;
import org.adorsys.encobject.filesystem.FsPersistenceFactory;
import org.adorsys.encobject.service.ContainerExistsException;
import org.adorsys.encobject.service.ContainerPersistence;
import org.adorsys.encobject.service.MissingKeyAlgorithmException;
import org.adorsys.encobject.service.MissingKeystoreAlgorithmException;
import org.adorsys.encobject.service.MissingKeystoreProviderException;
import org.adorsys.encobject.service.ObjectNotFoundException;
import org.adorsys.encobject.service.UnknownContainerException;
import org.adorsys.encobject.service.WrongKeystoreCredentialException;
import org.adorsys.envutils.EnvProperties;
import org.adorsys.jjwk.serverkey.KeyConverter;
import org.adorsys.jjwk.serverkey.KeyStoreUtils;
import org.adorsys.jjwk.serverkey.ServerKeyManager;
import org.adorsys.jjwk.serverkey.ServerKeysHolder;
import org.adorsys.jjwk.serverkey.SingleKeyUsageSelfSignedCertBuilder;
import org.adorsys.jkeygen.keypair.KeyPairBuilder;
import org.adorsys.jkeygen.keypair.SelfSignedKeyPairData;
import org.adorsys.jkeygen.keystore.KeyEntry;
import org.adorsys.jkeygen.keystore.KeyPairData;
import org.adorsys.jkeygen.keystore.KeyPairEntry;
import org.adorsys.jkeygen.keystore.KeystoreBuilder;
import org.adorsys.jkeygen.keystore.SecretKeyData;
import org.adorsys.jkeygen.keystore.SecretKeyEntry;
import org.adorsys.jkeygen.pwd.PasswordCallbackHandler;
import org.adorsys.jkeygen.secretkey.SecretKeyBuilder;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;

public abstract class AbstractServerKeyManagerConfig {
    protected ServerKeyManager serverKeyManager;
    private static int[] keyUsageSignature = new int[]{64};
    private static int[] keyUsageEncryption = new int[]{32, 16, 8};

    public abstract ServerKeyManager getServerKeyManager();

    protected abstract FsPersistenceFactory getFsPersistenceFactory();

    protected void initServerKeyManager(String appName) {
        KeyStore keyStore;
        String serverKeystoreContainer;
        ContainerPersistence containerPersistence = this.getFsPersistenceFactory().getContainerPersistence();
        if (!containerPersistence.containerExists(serverKeystoreContainer = EnvProperties.getEnvOrSysProp((String)"SERVER_KEYSTORE_CONTAINER", (String)(appName + "_serverkey_container")))) {
            try {
                containerPersistence.creteContainer(serverKeystoreContainer);
            }
            catch (ContainerExistsException e) {
                throw new IllegalStateException(e);
            }
        }
        String serverKeystoreName = EnvProperties.getEnvOrSysProp((String)"SERVER_KEYSTORE_NAME", (String)(appName + "_keystore"));
        String serverKeyPairName = EnvProperties.getEnvOrSysProp((String)"SERVER_KEYPAIR_NAME", (String)(appName + " Key Pair"));
        String serverKeyPairAliasPrefix = EnvProperties.getEnvOrSysProp((String)"SERVER_KEYALIAS_PREFIX", (String)(appName + "-"));
        String serverKeystorePassword = EnvProperties.getEnvOrSysProp((String)"KEYSTORE_PASSWORD", (boolean)true);
        if (StringUtils.isBlank((CharSequence)serverKeystorePassword)) {
            throw new IllegalStateException("Missing environment property KEYSTORE_PASSWORD");
        }
        String resetKeystore = EnvProperties.getEnvOrSysProp((String)"RESET_KEYSTORE", (boolean)true);
        char[] keystorePassword = serverKeystorePassword.toCharArray();
        char[] keyPairPassword = serverKeystorePassword.toCharArray();
        PasswordCallbackHandler keyPassHandler = new PasswordCallbackHandler(keystorePassword);
        PasswordCallbackHandler storePassHandler = new PasswordCallbackHandler(keyPairPassword);
        ObjectHandle handle = new ObjectHandle(serverKeystoreContainer, serverKeystoreName);
        if (BooleanUtils.toBoolean((String)resetKeystore)) {
            keyStore = this.createKeystore(serverKeystoreName, (CallbackHandler)storePassHandler, serverKeyPairName, serverKeyPairAliasPrefix, (CallbackHandler)keyPassHandler, handle);
        } else {
            try {
                keyStore = this.getFsPersistenceFactory().getKeystorePersistence().loadKeystore(handle, (CallbackHandler)storePassHandler);
            }
            catch (ObjectNotFoundException e) {
                keyStore = this.createKeystore(serverKeystoreName, (CallbackHandler)storePassHandler, serverKeyPairName, serverKeyPairAliasPrefix, (CallbackHandler)keyPassHandler, handle);
            }
            catch (IOException | CertificateException | MissingKeyAlgorithmException | MissingKeystoreAlgorithmException | MissingKeystoreProviderException | UnknownContainerException | WrongKeystoreCredentialException e) {
                throw new IllegalStateException(e);
            }
        }
        JWKSet privateKeys = KeyConverter.exportPrivateKeys((KeyStore)keyStore, (char[])keyPairPassword);
        JWKSet publicKeys = privateKeys.toPublicJWKSet();
        ServerKeysHolder serverKeysHolder = new ServerKeysHolder(privateKeys, publicKeys);
        this.serverKeyManager = new ServerKeyManager(serverKeysHolder);
    }

    private KeyStore createKeystore(String serverKeystoreName, CallbackHandler storePassHandler, String serverKeyPairName, String serverKeyPairAliasPrefix, CallbackHandler keyPassHandler, ObjectHandle handle) {
        String signKeyCountStr = EnvProperties.getEnvOrSysProp((String)"SERVER_SIGN_KEY_COUNT", (String)"5");
        int signKeyCount = Integer.parseInt(signKeyCountStr);
        String encKeyCountStr = EnvProperties.getEnvOrSysProp((String)"SERVER_ENCRYPT_KEY_COUNT", (String)"5");
        int encKeyCount = Integer.parseInt(encKeyCountStr);
        String secretKeyCountStr = EnvProperties.getEnvOrSysProp((String)"SERVER_SECRET_KEY_COUNT", (String)"5");
        int secKeyCount = Integer.parseInt(secretKeyCountStr);
        KeyStore keyStore = this.newKeystore(signKeyCount, encKeyCount, secKeyCount, serverKeystoreName, keyPassHandler, serverKeyPairName, serverKeyPairAliasPrefix);
        try {
            this.getFsPersistenceFactory().getKeystorePersistence().saveKeyStore(keyStore, storePassHandler, handle);
        }
        catch (NoSuchAlgorithmException | CertificateException | UnknownContainerException e) {
            throw new IllegalStateException(e);
        }
        return keyStore;
    }

    private KeyStore newKeystore(int numberOfSignKeypairs, int numberOfEncKeypairs, int numberOfSecretKeys, String serverKeystoreName, CallbackHandler storePassHandler, String serverKeyPairName, String serverKeyPairAliasPrefix) {
        try {
            int i;
            String keystoreType = EnvProperties.getEnvOrSysProp((String)"SERVER_KEYSTORE_TYPE", (String)"UBER");
            KeystoreBuilder keystoreBuilder = new KeystoreBuilder().withStoreType(keystoreType);
            for (i = 0; i < numberOfSignKeypairs; ++i) {
                keystoreBuilder = keystoreBuilder.withKeyEntry((KeyEntry)this.newKeyPair(serverKeyPairName, serverKeyPairAliasPrefix + UUID.randomUUID().toString(), storePassHandler, keyUsageSignature));
            }
            for (i = 0; i < numberOfEncKeypairs; ++i) {
                keystoreBuilder = keystoreBuilder.withKeyEntry((KeyEntry)this.newKeyPair(serverKeyPairName, serverKeyPairAliasPrefix + RandomStringUtils.randomAlphanumeric((int)5).toUpperCase(), storePassHandler, keyUsageEncryption));
            }
            for (i = 0; i < numberOfSecretKeys; ++i) {
                keystoreBuilder = keystoreBuilder.withKeyEntry((KeyEntry)AbstractServerKeyManagerConfig.newSecretKey(serverKeyPairAliasPrefix + RandomStringUtils.randomAlphanumeric((int)5).toUpperCase(), storePassHandler));
            }
            byte[] bs = keystoreBuilder.withStoreId(serverKeystoreName).build(storePassHandler);
            ByteArrayInputStream bis = new ByteArrayInputStream(bs);
            return KeyStoreUtils.loadKeyStore((InputStream)bis, (String)serverKeystoreName, (String)keystoreType, (CallbackHandler)storePassHandler);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private KeyPairEntry newKeyPair(String userName, String alias, CallbackHandler keyPassHandler, int[] keyUsages) {
        String keyAlgo = EnvProperties.getEnvOrSysProp((String)"SERVER_KEYSTORE_KEYPAIR_ALGO", (String)"RSA");
        String keySizeStr = EnvProperties.getEnvOrSysProp((String)"SERVER_KEYSTORE_KEYPAIR_SIZE", (String)"2048");
        String serverSigAlgo = EnvProperties.getEnvOrSysProp((String)"SERVER_KEYSTORE_RSA_SIGN_ALGO", (String)"SHA256withRSA");
        int keySize = Integer.parseInt(keySizeStr);
        KeyPair keyPair = new KeyPairBuilder().withKeyAlg(keyAlgo).withKeyLength(Integer.valueOf(keySize)).build();
        X500Name dn = new X500NameBuilder(BCStyle.INSTANCE).addRDN(BCStyle.CN, userName).build();
        SelfSignedKeyPairData keyPairData = new SingleKeyUsageSelfSignedCertBuilder().withSubjectDN(dn).withSignatureAlgo(serverSigAlgo).withNotAfterInDays(Integer.valueOf(900)).withCa(false).withKeyUsages(keyUsages).build(keyPair);
        return KeyPairData.builder().alias(alias).keyPair(keyPairData).passwordSource(keyPassHandler).build();
    }

    public static SecretKeyEntry newSecretKey(String alias, CallbackHandler secretKeyPassHandler) {
        String secretKeyAlgo = EnvProperties.getEnvOrSysProp((String)"SERVER_KEYSTORE_SECRET_KEY_ALGO", (String)"AES");
        String secretKeySizeStr = EnvProperties.getEnvOrSysProp((String)"SERVER_KEYSTORE_SECRET_KEY_SIZE", (String)"256");
        int keySize = Integer.parseInt(secretKeySizeStr);
        SecretKey secretKey = new SecretKeyBuilder().withKeyAlg(secretKeyAlgo).withKeyLength(Integer.valueOf(keySize)).build();
        return SecretKeyData.builder().secretKey(secretKey).alias(alias).passwordSource(secretKeyPassHandler).build();
    }
}

