/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.filesystem;

import org.adorsys.encobject.filesystem.FsBlobStoreFactory;
import org.adorsys.encobject.serverdata.ServerObjectPersistence;
import org.adorsys.encobject.service.BlobStoreConnection;
import org.adorsys.encobject.service.BlobStoreContextFactory;
import org.adorsys.encobject.service.BlobStoreKeystorePersistence;
import org.adorsys.encobject.service.ContainerPersistence;
import org.adorsys.encobject.service.EncObjectService;
import org.adorsys.encobject.service.KeystorePersistence;
import org.adorsys.encobject.service.ObjectPersistence;
import org.adorsys.encobject.service.StoreConnection;

public class FsPersistenceFactory {
    private KeystorePersistence keystorePersistence;
    private BlobStoreContextFactory blobStoreFactory;
    private ContainerPersistence containerPersistence;
    private ServerObjectPersistence serverObjectPersistence;
    private EncObjectService encObjectService;

    public FsPersistenceFactory(String baseDir) {
        this.blobStoreFactory = new FsBlobStoreFactory(baseDir);
        this.keystorePersistence = new BlobStoreKeystorePersistence(this.blobStoreFactory);
        BlobStoreConnection storeConnection = new BlobStoreConnection(this.blobStoreFactory);
        this.containerPersistence = new ContainerPersistence((StoreConnection)storeConnection);
        this.serverObjectPersistence = new ServerObjectPersistence(storeConnection);
        this.encObjectService = new EncObjectService(this.keystorePersistence, new ObjectPersistence((StoreConnection)storeConnection), this.containerPersistence);
    }

    public BlobStoreContextFactory getBlobStoreContextFactory() {
        return this.blobStoreFactory;
    }

    public KeystorePersistence getKeystorePersistence() {
        return this.keystorePersistence;
    }

    public ContainerPersistence getContainerPersistence() {
        return this.containerPersistence;
    }

    public BlobStoreContextFactory getBlobStoreFactory() {
        return this.blobStoreFactory;
    }

    public ServerObjectPersistence getServerObjectPersistence() {
        return this.serverObjectPersistence;
    }

    public EncObjectService getEncObjectService() {
        return this.encObjectService;
    }
}

