/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.filesystem;

import java.io.File;
import java.util.Properties;
import org.adorsys.encobject.service.BlobStoreContextFactory;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStoreContext;

public class FsBlobStoreFactory
implements BlobStoreContextFactory {
    Properties properties = new Properties();
    private String baseDir;

    public FsBlobStoreFactory(String baseDir) {
        this.baseDir = baseDir;
        this.properties.setProperty("jclouds.filesystem.basedir", baseDir);
    }

    public boolean existsOnFs(String container, String name) {
        File file = new File(this.baseDir + "/" + container + "/" + name);
        return file.exists();
    }

    @Override
    public BlobStoreContext alocate() {
        return (BlobStoreContext)ContextBuilder.newBuilder((String)"filesystem").overrides(this.properties).buildView(BlobStoreContext.class);
    }

    @Override
    public void dispose(BlobStoreContext blobStoreContext) {
        blobStoreContext.close();
    }
}

