/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.cryptoutils.extendendstoreconnection.impl.amazons3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.cryptoutils.utils.Frame;
import org.adorsys.cryptoutils.utils.HexUtil;
import org.adorsys.encobject.complextypes.BucketDirectory;
import org.adorsys.encobject.complextypes.BucketPath;
import org.adorsys.encobject.complextypes.BucketPathUtil;
import org.adorsys.encobject.domain.Payload;
import org.adorsys.encobject.domain.PayloadStream;
import org.adorsys.encobject.domain.StorageMetadata;
import org.adorsys.encobject.domain.StorageType;
import org.adorsys.encobject.exceptions.StorageConnectionException;
import org.adorsys.encobject.filesystem.StorageMetadataFlattenerGSON;
import org.adorsys.encobject.service.api.ExtendedStoreConnection;
import org.adorsys.encobject.service.impl.SimplePayloadImpl;
import org.adorsys.encobject.service.impl.SimplePayloadStreamImpl;
import org.adorsys.encobject.service.impl.SimpleStorageMetadataImpl;
import org.adorsys.encobject.types.ExtendedStoreConnectionType;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.adorsys.encobject.types.connection.AmazonS3AccessKey;
import org.adorsys.encobject.types.connection.AmazonS3Region;
import org.adorsys.encobject.types.connection.AmazonS3RootBucketName;
import org.adorsys.encobject.types.connection.AmazonS3SecretKey;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RealAmazonS3ExtendedStoreConnection
implements ExtendedStoreConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealAmazonS3ExtendedStoreConnection.class);
    private static final Logger SPECIAL_LOGGER = LoggerFactory.getLogger((String)"SPECIAL_LOGGER");
    private AmazonS3 connection = null;
    private static final String AMAZONS3_TMP_FILE_PREFIX = "AMAZONS3_TMP_FILE_";
    private static final String AMAZONS3_TMP_FILE_SUFFIX = "";
    private static final String STORAGE_METADATA_KEY = "StorageMetadata";
    private StorageMetadataFlattenerGSON gsonHelper = new StorageMetadataFlattenerGSON();
    private static final int AMAZON_S3_META_LIMIT = 2048;
    private BucketDirectory amazonS3RootBucket;
    private BucketDirectory amazonS3RootContainersBucket;
    private AmazonS3Region amazonS3Region;

    public RealAmazonS3ExtendedStoreConnection(URL url, final AmazonS3AccessKey accessKey, final AmazonS3SecretKey secretKey, AmazonS3Region anAmazonS3Region, AmazonS3RootBucketName anAmazonS3RootBucketName) {
        this.amazonS3Region = anAmazonS3Region;
        this.amazonS3RootBucket = new BucketDirectory(anAmazonS3RootBucketName.getValue());
        this.amazonS3RootContainersBucket = new BucketDirectory(this.amazonS3RootBucket.getObjectHandle().getContainer() + ".containers");
        Frame frame = new Frame();
        frame.add("USE AMAZON S3 COMPLIANT SYSTEM");
        frame.add("(has be up and running)");
        frame.add("url: " + url.toString());
        frame.add("accessKey:   " + accessKey);
        frame.add("secretKey:   " + secretKey);
        frame.add("region:      " + this.amazonS3Region);
        frame.add("root bucket: " + this.amazonS3RootBucket);
        LOGGER.info(frame.toString());
        AWSCredentialsProvider credentialsProvider = new AWSCredentialsProvider(){

            public AWSCredentials getCredentials() {
                return new BasicAWSCredentials(accessKey.getValue(), secretKey.getValue());
            }

            public void refresh() {
            }
        };
        AwsClientBuilder.EndpointConfiguration endpoint = new AwsClientBuilder.EndpointConfiguration(url.toString(), this.amazonS3Region.getValue());
        ClientConfiguration clientConfig = new ClientConfiguration();
        clientConfig.setProtocol(Protocol.HTTP);
        clientConfig.disableSocketProxy();
        this.connection = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(credentialsProvider)).withEndpointConfiguration(endpoint)).withClientConfiguration(clientConfig)).withPayloadSigningEnabled(Boolean.valueOf(false))).enablePathStyleAccess()).build();
        if (!this.connection.doesBucketExistV2(this.amazonS3RootBucket.getObjectHandle().getContainer())) {
            this.connection.createBucket(this.amazonS3RootBucket.getObjectHandle().getContainer());
        }
        if (!this.connection.doesBucketExistV2(this.amazonS3RootContainersBucket.getObjectHandle().getContainer())) {
            this.connection.createBucket(this.amazonS3RootContainersBucket.getObjectHandle().getContainer());
        }
    }

    public void putBlob(BucketPath bucketPath, Payload payload) {
        LOGGER.debug("putBlob " + bucketPath);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(payload.getData());
        SimplePayloadStreamImpl payloadStream = new SimplePayloadStreamImpl(payload.getStorageMetadata(), (InputStream)inputStream);
        this.putBlobStreamWithMemory(bucketPath, (PayloadStream)payloadStream, payload.getData().length);
    }

    public Payload getBlob(BucketPath bucketPath) {
        return this.getBlob(bucketPath, null);
    }

    public Payload getBlob(BucketPath bucketPath, StorageMetadata storageMetadata) {
        try {
            PayloadStream payloadStream = this.getBlobStream(bucketPath);
            byte[] content = IOUtils.toByteArray((InputStream)payloadStream.openStream());
            SimplePayloadImpl payload = new SimplePayloadImpl(payloadStream.getStorageMetadata(), content);
            return payload;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public void putBlobStream(BucketPath bucketPath, PayloadStream payloadStream) {
        this.putBlobStreamWithTempFile(bucketPath, payloadStream);
    }

    public PayloadStream getBlobStream(BucketPath bucketPath) {
        return this.getBlobStream(bucketPath, null);
    }

    public PayloadStream getBlobStream(BucketPath abucketPath, StorageMetadata storageMetadata) {
        LOGGER.debug("getBlobStream " + abucketPath);
        BucketPath bucketPath = this.amazonS3RootBucket.append(abucketPath);
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucketPath.getObjectHandle().getContainer(), bucketPath.getObjectHandle().getName());
        S3Object object = this.connection.getObject(getObjectRequest);
        S3ObjectInputStream objectContent = object.getObjectContent();
        StorageMetadata storageMetadata2 = this.getStorageMetadataFromObjectdata(object.getObjectMetadata(), abucketPath);
        SimplePayloadStreamImpl payloadStream = new SimplePayloadStreamImpl(storageMetadata2, (InputStream)objectContent);
        LOGGER.debug("read ok for " + bucketPath);
        return payloadStream;
    }

    public void putBlob(BucketPath bucketPath, byte[] bytes) {
        LOGGER.debug("putBlob " + bucketPath);
        this.putBlob(bucketPath, (Payload)new SimplePayloadImpl((StorageMetadata)new SimpleStorageMetadataImpl(), bytes));
    }

    public StorageMetadata getStorageMetadata(BucketPath abucketPath) {
        SPECIAL_LOGGER.debug("readmetadata " + abucketPath);
        LOGGER.debug("getStorageMetadata " + abucketPath);
        BucketPath bucketPath = this.amazonS3RootBucket.append(abucketPath);
        GetObjectMetadataRequest getObjectMetadataRequest = new GetObjectMetadataRequest(bucketPath.getObjectHandle().getContainer(), bucketPath.getObjectHandle().getName());
        ObjectMetadata objectMetadata = this.connection.getObjectMetadata(getObjectMetadataRequest);
        StorageMetadata storageMetadata = this.getStorageMetadataFromObjectdata(objectMetadata, abucketPath);
        return storageMetadata;
    }

    public boolean blobExists(BucketPath abucketPath) {
        LOGGER.debug("blobExists " + abucketPath);
        BucketPath bucketPath = this.amazonS3RootBucket.append(abucketPath);
        try {
            this.connection.getObjectMetadata(bucketPath.getObjectHandle().getContainer(), bucketPath.getObjectHandle().getName());
            LOGGER.debug("blob exists " + abucketPath + " TRUE");
            return true;
        }
        catch (Exception e) {
            LOGGER.debug("blob exists " + abucketPath + " FALSE");
            return false;
        }
    }

    public void removeBlob(BucketPath abucketPath) {
        LOGGER.debug("removeBlob " + abucketPath);
        BucketPath bucketPath = this.amazonS3RootBucket.append(abucketPath);
        this.connection.deleteObject(bucketPath.getObjectHandle().getContainer(), bucketPath.getObjectHandle().getName());
    }

    public void removeBlobFolder(BucketDirectory bucketDirectory) {
        LOGGER.debug("removeBlobFolder " + bucketDirectory);
        if (bucketDirectory.getObjectHandle().getName() == null) {
            throw new StorageConnectionException("not a valid bucket directory " + bucketDirectory);
        }
        this.internalRemoveMultiple(bucketDirectory);
    }

    public boolean containerExists(BucketDirectory bucketDirectory) {
        BucketPath bucketPath = this.amazonS3RootContainersBucket.appendName(bucketDirectory.getObjectHandle().getContainer());
        try {
            this.connection.getObjectMetadata(bucketPath.getObjectHandle().getContainer(), bucketPath.getObjectHandle().getName());
            LOGGER.debug("containerExists " + bucketDirectory + " TRUE");
            return true;
        }
        catch (Exception e) {
            LOGGER.debug("containerExists " + bucketDirectory + " FALSE (EXCEPTION)");
            return false;
        }
    }

    public void createContainer(BucketDirectory bucketDirectory) {
        LOGGER.debug("createContainer " + bucketDirectory);
        if (!this.containerExists(bucketDirectory)) {
            BucketPath bucketPath = this.amazonS3RootContainersBucket.appendName(bucketDirectory.getObjectHandle().getContainer());
            byte[] content = "x".getBytes();
            LOGGER.debug("write " + bucketPath);
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)content.length);
            ByteArrayInputStream bis = new ByteArrayInputStream(content);
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketPath.getObjectHandle().getContainer(), bucketPath.getObjectHandle().getName(), (InputStream)bis, objectMetadata);
            PutObjectResult putObjectResult = this.connection.putObject(putObjectRequest);
        }
    }

    public void deleteContainer(BucketDirectory bucketDirectory) {
        LOGGER.debug("deleteContainer " + bucketDirectory);
        this.internalRemoveMultiple(new BucketDirectory(bucketDirectory.getObjectHandle().getContainer()));
    }

    public List<StorageMetadata> list(BucketDirectory abucketDirectory, ListRecursiveFlag listRecursiveFlag) {
        LOGGER.debug("list " + abucketDirectory);
        List<StorageMetadata> returnList = new ArrayList<StorageMetadata>();
        if (!this.containerExists(abucketDirectory)) {
            LOGGER.debug("return empty list for " + abucketDirectory);
            return returnList;
        }
        if (this.blobExists(new BucketPath(BucketPathUtil.getAsString((BucketDirectory)abucketDirectory)))) {
            return new ArrayList<StorageMetadata>();
        }
        BucketDirectory bucketDirectory = this.amazonS3RootBucket.append(abucketDirectory);
        String container = bucketDirectory.getObjectHandle().getContainer();
        String prefix = bucketDirectory.getObjectHandle().getName();
        prefix = prefix == null ? "/" : "/" + prefix;
        LOGGER.debug("search in " + container + " with prefix " + prefix + " " + listRecursiveFlag);
        String searchKey = prefix.substring(1);
        ObjectListing ol = this.connection.listObjects(container, searchKey);
        ArrayList<String> keys = new ArrayList<String>();
        ol.getObjectSummaries().forEach(el -> keys.add("/" + el.getKey()));
        returnList = this.filter(container, prefix, keys, listRecursiveFlag);
        if (LOGGER.isTraceEnabled()) {
            returnList.forEach(el -> LOGGER.trace("return for " + abucketDirectory + " :" + el.getName() + " type " + el.getType()));
        }
        return returnList;
    }

    public List<BucketDirectory> listAllBuckets() {
        LOGGER.debug("listAllBuckets");
        ArrayList<BucketDirectory> buckets = new ArrayList<BucketDirectory>();
        ObjectListing ol = this.connection.listObjects(this.amazonS3RootContainersBucket.getObjectHandle().getContainer());
        ol.getObjectSummaries().forEach(bucket -> buckets.add(new BucketDirectory(bucket.getKey())));
        return buckets;
    }

    public ExtendedStoreConnectionType getType() {
        return ExtendedStoreConnectionType.AMAZONS3;
    }

    public void cleanDatabase() {
        LOGGER.warn("DELETE DATABASE");
        for (BucketDirectory bucketDirectory : this.listAllBuckets()) {
            this.deleteContainer(bucketDirectory);
        }
    }

    public void showDatabase() {
        try {
            ObjectListing ol = this.connection.listObjects(this.amazonS3RootBucket.getObjectHandle().getContainer());
            ArrayList keys = new ArrayList();
            for (S3ObjectSummary key : ol.getObjectSummaries()) {
                LOGGER.debug(key.getKey());
            }
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    List<StorageMetadata> filter(String container, String prefix, List<String> keys, ListRecursiveFlag recursive) {
        ArrayList<StorageMetadata> result = new ArrayList<StorageMetadata>();
        HashSet<String> dirs = new HashSet<String>();
        int numberOfDelimitersOfPrefix = StringUtils.countMatches((CharSequence)prefix, (CharSequence)"/");
        if (prefix.length() > "/".length()) {
            ++numberOfDelimitersOfPrefix;
        }
        int numberOfDelimitersExpected = numberOfDelimitersOfPrefix;
        keys.forEach(key -> {
            int numberOfDelimitersOfKey;
            if (recursive.equals((Object)ListRecursiveFlag.TRUE)) {
                result.add(this.getStorageMetadata(new BucketPath(key)));
            } else {
                numberOfDelimitersOfKey = StringUtils.countMatches((CharSequence)key, (CharSequence)"/");
                if (numberOfDelimitersOfKey == numberOfDelimitersExpected) {
                    result.add(this.getStorageMetadata(new BucketPath(key)));
                }
            }
            if (recursive.equals((Object)ListRecursiveFlag.TRUE)) {
                int lastDelimiter = key.lastIndexOf("/");
                String dir = key.substring(0, lastDelimiter);
                if (dir.length() == 0) {
                    dir = "/";
                }
                dirs.add(dir);
            } else {
                numberOfDelimitersOfKey = StringUtils.countMatches((CharSequence)key, (CharSequence)"/");
                if (numberOfDelimitersOfKey == numberOfDelimitersExpected + 1) {
                    int lastDelimiter = key.lastIndexOf("/");
                    String dir = key.substring(0, lastDelimiter);
                    dirs.add(dir);
                }
            }
        });
        dirs.add(prefix);
        for (String dir : dirs) {
            SimpleStorageMetadataImpl storageMetadata = new SimpleStorageMetadataImpl();
            storageMetadata.setType(StorageType.FOLDER);
            storageMetadata.setName(BucketPathUtil.getAsString((BucketDirectory)new BucketDirectory(new BucketPath(dir))));
            result.add((StorageMetadata)storageMetadata);
        }
        return result;
    }

    private void putBlobStreamWithMemory(BucketPath abucketPath, PayloadStream payloadStream, int size) {
        try {
            LOGGER.debug("putBlobStreamWithMemory " + abucketPath + " with known length " + size);
            SimpleStorageMetadataImpl storageMetadata = new SimpleStorageMetadataImpl(payloadStream.getStorageMetadata());
            storageMetadata.setName(BucketPathUtil.getAsString((BucketPath)abucketPath));
            storageMetadata.setType(StorageType.BLOB);
            ObjectMetadata objectMetadata = this.geteObjectMetadataFromStorageMetadata(storageMetadata);
            objectMetadata.setContentLength((long)size);
            BucketPath bucketPath = this.amazonS3RootBucket.append(abucketPath);
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketPath.getObjectHandle().getContainer(), bucketPath.getObjectHandle().getName(), payloadStream.openStream(), objectMetadata);
            PutObjectResult putObjectResult = this.connection.putObject(putObjectRequest);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    private void putBlobStreamWithTempFile(BucketPath abucketPath, PayloadStream payloadStream) {
        try {
            LOGGER.debug("putBlobStreamWithTempFile " + abucketPath + " to tmpfile with unknown size");
            InputStream is = payloadStream.openStream();
            File targetFile = File.createTempFile(AMAZONS3_TMP_FILE_PREFIX, AMAZONS3_TMP_FILE_SUFFIX);
            Files.copy(is, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            IOUtils.closeQuietly((InputStream)is);
            LOGGER.debug(abucketPath + " with tmpfile " + targetFile.getAbsolutePath() + " written with " + targetFile.length() + " bytes -> will now be copied to ceph");
            FileInputStream fis = new FileInputStream(targetFile);
            SimpleStorageMetadataImpl storageMetadata = new SimpleStorageMetadataImpl(payloadStream.getStorageMetadata());
            storageMetadata.setName(BucketPathUtil.getAsString((BucketPath)abucketPath));
            storageMetadata.setType(StorageType.BLOB);
            ObjectMetadata objectMetadata = this.geteObjectMetadataFromStorageMetadata(storageMetadata);
            objectMetadata.setContentLength(targetFile.length());
            BucketPath bucketPath = this.amazonS3RootBucket.append(abucketPath);
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketPath.getObjectHandle().getContainer(), bucketPath.getObjectHandle().getName(), (InputStream)fis, objectMetadata);
            PutObjectResult putObjectResult = this.connection.putObject(putObjectRequest);
            IOUtils.closeQuietly((InputStream)fis);
            LOGGER.debug("stored " + bucketPath + " to ceph with size " + targetFile.length());
            targetFile.delete();
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    private ObjectMetadata geteObjectMetadataFromStorageMetadata(SimpleStorageMetadataImpl storageMetadata) {
        String metadataAsString = this.gsonHelper.toJson((StorageMetadata)storageMetadata);
        String metadataAsHexString = HexUtil.convertBytesToHexString((byte[])metadataAsString.getBytes());
        HashMap<String, String> userMetaData = new HashMap<String, String>();
        userMetaData.put(STORAGE_METADATA_KEY, metadataAsHexString);
        int sizeOfMetadataHexString = metadataAsHexString.length();
        if (sizeOfMetadataHexString > 2048) {
            throw new BaseException("Die Metadaten haben im HexFormat eine L\u00e4nge von " + sizeOfMetadataHexString + ". Das Limit liegt aber bei " + 2048 + ". Der original String der Daten ist " + metadataAsString.length() + " Zeichen gro\u00df. Hier die Daten:" + metadataAsString);
        }
        LOGGER.debug("SIZE OF METADATA IS IN HEXFORMAT " + sizeOfMetadataHexString);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setUserMetadata(userMetaData);
        return objectMetadata;
    }

    private StorageMetadata getStorageMetadataFromObjectdata(ObjectMetadata objectMetadata, BucketPath bucketPath) {
        String metadataAsHexString = (String)objectMetadata.getUserMetadata().get(STORAGE_METADATA_KEY);
        if (metadataAsHexString == null) {
            throw new BaseException("UserData do not contain mandatory StorageMetadata for " + bucketPath);
        }
        String metadataAsString = new String(HexUtil.convertHexStringToBytes((String)metadataAsHexString));
        return this.gsonHelper.fromJson(metadataAsString);
    }

    private void internalRemoveMultiple(BucketDirectory abucketDirectory) {
        LOGGER.debug("internalRemoveMultiple " + abucketDirectory);
        if (!this.containerExists(abucketDirectory)) {
            return;
        }
        BucketDirectory bucketDirectory = this.amazonS3RootBucket.append(abucketDirectory);
        String container = bucketDirectory.getObjectHandle().getContainer();
        String prefix = bucketDirectory.getObjectHandle().getName();
        if (prefix == null) {
            prefix = AMAZONS3_TMP_FILE_SUFFIX;
        }
        LOGGER.debug("listObjects(" + container + "," + prefix + ")");
        ObjectListing ol = this.connection.listObjects(container, prefix);
        if (ol.getObjectSummaries().isEmpty()) {
            LOGGER.debug("no files found in " + container + " with prefix " + prefix);
        }
        ArrayList<DeleteObjectsRequest.KeyVersion> keys = new ArrayList<DeleteObjectsRequest.KeyVersion>();
        for (S3ObjectSummary key : ol.getObjectSummaries()) {
            keys.add(new DeleteObjectsRequest.KeyVersion(key.getKey()));
            if (keys.size() != 100) continue;
            DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(container);
            deleteObjectsRequest.setKeys(keys);
            LOGGER.debug("DELETE CHUNK CONTENTS OF BUCKET " + container + " with " + keys.size() + " elements");
            DeleteObjectsResult deleteObjectsResult = this.connection.deleteObjects(deleteObjectsRequest);
            LOGGER.debug("SERVER CONFIRMED DELETION OF " + deleteObjectsResult.getDeletedObjects().size() + " elements");
            ObjectListing ol2 = this.connection.listObjects(container);
            LOGGER.debug("SERVER has remaining " + ol2.getObjectSummaries().size() + " elements");
            if (ol2.getObjectSummaries().size() != ol.getObjectSummaries().size()) continue;
            throw new BaseException("Fatal error. Server confirmied deleltion of " + keys.size() + " elements, but still " + ol.getObjectSummaries().size() + " elementents in " + container);
        }
        if (!keys.isEmpty()) {
            DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(container);
            deleteObjectsRequest.setKeys(keys);
            LOGGER.debug("DELETE CONTENTS OF BUCKET " + container + " with " + keys.size() + " elements");
            DeleteObjectsResult deleteObjectsResult = this.connection.deleteObjects(deleteObjectsRequest);
            LOGGER.debug("SERVER CONFIRMED DELETION OF " + deleteObjectsResult.getDeletedObjects().size() + " elements");
        }
        if (abucketDirectory.getObjectHandle().getName() == null) {
            BucketPath containerFile = this.amazonS3RootContainersBucket.appendName(abucketDirectory.getObjectHandle().getContainer());
            this.connection.deleteObject(containerFile.getObjectHandle().getContainer(), containerFile.getObjectHandle().getName());
        }
    }
}

