/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.cryptoutils.extendendstoreconnection.impl.amazons3;

import java.net.URL;
import java.util.StringTokenizer;
import org.adorsys.cryptoutils.extendendstoreconnection.impl.amazons3.AmazonS3AccessKey;
import org.adorsys.cryptoutils.extendendstoreconnection.impl.amazons3.AmazonS3ExtendedStoreConnection;
import org.adorsys.cryptoutils.extendendstoreconnection.impl.amazons3.AmazonS3Region;
import org.adorsys.cryptoutils.extendendstoreconnection.impl.amazons3.AmazonS3RootBucket;
import org.adorsys.cryptoutils.extendendstoreconnection.impl.amazons3.AmazonS3SecretKey;
import org.adorsys.encobject.exceptions.ParamParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonS3ParamParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmazonS3ParamParser.class);
    private URL url;
    private AmazonS3AccessKey amazonS3AccessKey;
    private AmazonS3SecretKey amazonS3SecretKey;
    private static final String DELIMITER = ",";
    private static final String EXPECTED_PARAMS = "<url>,<accesskey>,<secretkey>[,<region>][,<rootbucket>]";
    private AmazonS3Region amazonS3Region = AmazonS3ExtendedStoreConnection.DEFAULT_REGION;
    private AmazonS3RootBucket amazonS3RootBucket = AmazonS3ExtendedStoreConnection.DEFAULT_BUCKET;

    public AmazonS3ParamParser(String params) {
        LOGGER.debug("parse:" + params);
        try {
            StringTokenizer st = new StringTokenizer(params, DELIMITER);
            this.url = new URL(st.nextToken());
            this.amazonS3AccessKey = new AmazonS3AccessKey(st.nextToken());
            this.amazonS3SecretKey = new AmazonS3SecretKey(st.nextToken());
            if (st.hasMoreTokens()) {
                this.amazonS3Region = new AmazonS3Region(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                this.amazonS3RootBucket = new AmazonS3RootBucket(st.nextToken());
            }
        }
        catch (Exception e) {
            throw new ParamParserException(params, DELIMITER, EXPECTED_PARAMS);
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public AmazonS3AccessKey getAmazonS3AccessKey() {
        return this.amazonS3AccessKey;
    }

    public AmazonS3SecretKey getAmazonS3SecretKey() {
        return this.amazonS3SecretKey;
    }

    public AmazonS3Region getAmazonS3Region() {
        return this.amazonS3Region;
    }

    public AmazonS3RootBucket getAmazonS3RootBucket() {
        return this.amazonS3RootBucket;
    }
}

