/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.bg.monitoring.server.influxdb;

import de.adorsys.bg.monitoring.api.MonitoringMessage;
import de.adorsys.bg.monitoring.server.MonitoringMessageHandler;
import de.adorsys.bg.monitoring.server.influxdb.InfluxProperties;
import java.util.Map;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.Point;
import org.springframework.stereotype.Component;

@Component
public class InfluxMonitoringMessageHandler
implements MonitoringMessageHandler {
    private final String url;
    private final String database;
    private final String username;
    private final String password;

    public InfluxMonitoringMessageHandler(InfluxProperties influxProperties) {
        this.url = influxProperties.getUrl();
        this.database = influxProperties.getDatabase();
        this.username = influxProperties.getUsername();
        this.password = influxProperties.getPassword();
    }

    public void handle(MonitoringMessage message) {
        Point monitoringDataPoint = this.createPoint(message);
        this.save(monitoringDataPoint);
    }

    private Point createPoint(MonitoringMessage message) {
        Point.Builder pointBuilder = Point.measurement((String)"monitoring_data");
        if (message.getTimestamp() != null) {
            pointBuilder.addField("timestamp", message.getTimestamp().toString());
        }
        if (message.getCorrelationId() != null) {
            pointBuilder.addField("correlation_id", message.getCorrelationId());
        }
        if (message.getBankCode() != null) {
            pointBuilder.tag("bank_code", message.getBankCode());
        }
        if (message.getIban() != null) {
            pointBuilder.addField("iban", message.getIban());
        }
        if (message.getSource() != null) {
            pointBuilder.addField("source", message.getSource());
        }
        if (message.getFunctionName() != null) {
            pointBuilder.addField("function_name", message.getFunctionName());
        }
        if (message.getFields() != null && !message.getFields().isEmpty()) {
            for (Map.Entry field : message.getFields().entrySet()) {
                if (field.getKey() == null || field.getValue() == null) continue;
                pointBuilder.addField((String)field.getKey(), (String)field.getValue());
            }
        }
        pointBuilder.addField("status", (Number)message.getStatus());
        if (message.getErrorMessage() != null) {
            pointBuilder.addField("error_message", message.getErrorMessage());
        }
        return pointBuilder.build();
    }

    private void save(Point monitoringDataPoint) {
        try (InfluxDB connect = this.createConnection();){
            connect.setDatabase(this.database);
            connect.write(monitoringDataPoint);
        }
    }

    private InfluxDB createConnection() {
        if (this.username != null && this.password != null) {
            return InfluxDBFactory.connect((String)this.url, (String)this.username, (String)this.password);
        }
        return InfluxDBFactory.connect((String)this.url);
    }
}

