/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.bg.monitoring.api;

import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class MonitoringMessage {
    private final Instant timestamp;
    private final String correlationId;
    private final String bankCode;
    private final String iban;
    private final String source;
    private final String functionName;
    private final Map<String, String> fields;
    private final Integer status;
    private final String errorMessage;

    public static Builder builder() {
        return new Builder();
    }

    public MonitoringMessage(Builder builder) {
        this.timestamp = builder.getTimestamp();
        this.correlationId = builder.getCorrelationId();
        this.bankCode = builder.getBankCode();
        this.iban = builder.getIban();
        this.source = builder.getSource();
        this.functionName = builder.getFunctionName();
        Map<String, String> fields = builder.getFields();
        if (fields == null) {
            this.fields = null;
        } else {
            if (fields.size() > 5) {
                throw new IllegalArgumentException("Up to 5 fields are allowed");
            }
            this.fields = Collections.unmodifiableMap(fields);
        }
        this.status = builder.getStatus();
        this.errorMessage = builder.getErrorMessage();
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public String getIban() {
        return this.iban;
    }

    public String getSource() {
        return this.source;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitoringMessage that = (MonitoringMessage)o;
        return Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.correlationId, that.correlationId) && Objects.equals(this.bankCode, that.bankCode) && Objects.equals(this.iban, that.iban) && Objects.equals(this.source, that.source) && Objects.equals(this.functionName, that.functionName) && Objects.equals(this.fields, that.fields) && Objects.equals(this.status, that.status) && Objects.equals(this.errorMessage, that.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.correlationId, this.bankCode, this.iban, this.source, this.functionName, this.fields, this.status, this.errorMessage);
    }

    public String toString() {
        return "MonitoringMessage{timestamp=" + this.timestamp + ", correlationId='" + this.correlationId + '\'' + ", bankCode='" + this.bankCode + '\'' + ", iban='" + this.iban + '\'' + ", source='" + this.source + '\'' + ", functionName='" + this.functionName + '\'' + ", fields=" + this.fields + ", status=" + this.status + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    public static final class Builder {
        private Instant timestamp;
        private String correlationId;
        private String bankCode;
        private String iban;
        private String source;
        private String functionName;
        private Map<String, String> fields;
        private Integer status;
        private String errorMessage;

        private Builder() {
        }

        public MonitoringMessage build() {
            return new MonitoringMessage(this);
        }

        public Instant getTimestamp() {
            return this.timestamp;
        }

        public Builder setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public String getCorrelationId() {
            return this.correlationId;
        }

        public Builder setCorrelationId(String correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        public String getBankCode() {
            return this.bankCode;
        }

        public Builder setBankCode(String bankCode) {
            this.bankCode = bankCode;
            return this;
        }

        public String getIban() {
            return this.iban;
        }

        public Builder setIban(String iban) {
            this.iban = iban;
            return this;
        }

        public String getSource() {
            return this.source;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public Builder setFunctionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public Map<String, String> getFields() {
            return this.fields;
        }

        public Builder setFields(Map<String, String> fields) {
            this.fields = fields;
            return this;
        }

        public String getField(String name) {
            if (this.fields == null) {
                return null;
            }
            return this.fields.get(name);
        }

        public Builder setField(String name, String value) {
            if (this.fields == null) {
                this.fields = new LinkedHashMap<String, String>();
            }
            this.fields.put(name, value);
            return this;
        }

        public Integer getStatus() {
            return this.status;
        }

        public Builder setStatus(Integer status) {
            this.status = status;
            return this;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public Builder setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }
    }
}

