/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.AccountAccess;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Content of the body of a consent request. ")
@Validated
public class Consents {
    @JsonProperty(value="access")
    private AccountAccess access = null;
    @JsonProperty(value="recurringIndicator")
    private Boolean recurringIndicator = null;
    @JsonProperty(value="validUntil")
    private LocalDate validUntil = null;
    @JsonProperty(value="frequencyPerDay")
    private Integer frequencyPerDay = null;
    @JsonProperty(value="combinedServiceIndicator")
    private Boolean combinedServiceIndicator = null;

    public Consents access(AccountAccess access) {
        this.access = access;
        return this;
    }

    @ApiModelProperty(required=true)
    @NotNull
    @Valid
    public AccountAccess getAccess() {
        return this.access;
    }

    public void setAccess(AccountAccess access) {
        this.access = access;
    }

    public Consents recurringIndicator(Boolean recurringIndicator) {
        this.recurringIndicator = recurringIndicator;
        return this;
    }

    @ApiModelProperty(required=true)
    @NotNull
    public Boolean getRecurringIndicator() {
        return this.recurringIndicator;
    }

    public void setRecurringIndicator(Boolean recurringIndicator) {
        this.recurringIndicator = recurringIndicator;
    }

    public Consents validUntil(LocalDate validUntil) {
        this.validUntil = validUntil;
        return this;
    }

    @ApiModelProperty(required=true)
    @NotNull
    @Valid
    public LocalDate getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(LocalDate validUntil) {
        this.validUntil = validUntil;
    }

    public Consents frequencyPerDay(Integer frequencyPerDay) {
        this.frequencyPerDay = frequencyPerDay;
        return this;
    }

    @ApiModelProperty(required=true)
    @NotNull
    public Integer getFrequencyPerDay() {
        return this.frequencyPerDay;
    }

    public void setFrequencyPerDay(Integer frequencyPerDay) {
        this.frequencyPerDay = frequencyPerDay;
    }

    public Consents combinedServiceIndicator(Boolean combinedServiceIndicator) {
        this.combinedServiceIndicator = combinedServiceIndicator;
        return this;
    }

    @ApiModelProperty(required=true, value="If \"true\" indicates that a payment initiation service will be addressed in the same \"session\". ")
    @NotNull
    public Boolean isCombinedServiceIndicator() {
        return this.combinedServiceIndicator;
    }

    public void setCombinedServiceIndicator(Boolean combinedServiceIndicator) {
        this.combinedServiceIndicator = combinedServiceIndicator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Consents consents = (Consents)o;
        return Objects.equals(this.access, consents.access) && Objects.equals(this.recurringIndicator, consents.recurringIndicator) && Objects.equals(this.validUntil, consents.validUntil) && Objects.equals(this.frequencyPerDay, consents.frequencyPerDay) && Objects.equals(this.combinedServiceIndicator, consents.combinedServiceIndicator);
    }

    public int hashCode() {
        return Objects.hash(this.access, this.recurringIndicator, this.validUntil, this.frequencyPerDay, this.combinedServiceIndicator);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Consents {\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("    recurringIndicator: ").append(this.toIndentedString(this.recurringIndicator)).append("\n");
        sb.append("    validUntil: ").append(this.toIndentedString(this.validUntil)).append("\n");
        sb.append("    frequencyPerDay: ").append(this.toIndentedString(this.frequencyPerDay)).append("\n");
        sb.append("    combinedServiceIndicator: ").append(this.toIndentedString(this.combinedServiceIndicator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

