/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.Amount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="JSON Request body for the \"Confirmation of Funds Service\"  <table>  <tr>    <td>cardNumber</td>    <td>String </td>   <td>Optional</td>   <td>Card Number of the card issued by the PIISP. Should be delivered if available.</td> </tr>  <tr>   <td>account</td>   <td> Account Reference</td>   <td>Mandatory</td>   <td>PSU's account number.</td> </tr>  <tr>    <td>payee</td>   <td>Max70Text</td>   <td>Optional</td>   <td>The merchant where the card is accepted as an information to the PSU.</td> </tr>  <tr>   <td>instructedAmount</td>   <td>Amount</td>   <td>Mandatory</td>   <td>Transaction amount to be checked within the funds check mechanism.</td> </tr>  </table> ")
@Validated
public class ConfirmationOfFunds {
    @JsonProperty(value="cardNumber")
    private String cardNumber = null;
    @JsonProperty(value="account")
    private Object account = null;
    @JsonProperty(value="payee")
    private String payee = null;
    @JsonProperty(value="instructedAmount")
    private Amount instructedAmount = null;

    public ConfirmationOfFunds cardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
        return this;
    }

    @ApiModelProperty(value="Card Number of the card issued by the PIISP.  Should be delivered if available. ")
    public String getCardNumber() {
        return this.cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public ConfirmationOfFunds account(Object account) {
        this.account = account;
        return this;
    }

    @ApiModelProperty(required=true)
    @NotNull
    public Object getAccount() {
        return this.account;
    }

    public void setAccount(Object account) {
        this.account = account;
    }

    public ConfirmationOfFunds payee(String payee) {
        this.payee = payee;
        return this;
    }

    @ApiModelProperty(value="Name payee")
    @Size(max=70)
    public String getPayee() {
        return this.payee;
    }

    public void setPayee(String payee) {
        this.payee = payee;
    }

    public ConfirmationOfFunds instructedAmount(Amount instructedAmount) {
        this.instructedAmount = instructedAmount;
        return this;
    }

    @ApiModelProperty(required=true)
    @NotNull
    @Valid
    public Amount getInstructedAmount() {
        return this.instructedAmount;
    }

    public void setInstructedAmount(Amount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfirmationOfFunds confirmationOfFunds = (ConfirmationOfFunds)o;
        return Objects.equals(this.cardNumber, confirmationOfFunds.cardNumber) && Objects.equals(this.account, confirmationOfFunds.account) && Objects.equals(this.payee, confirmationOfFunds.payee) && Objects.equals(this.instructedAmount, confirmationOfFunds.instructedAmount);
    }

    public int hashCode() {
        return Objects.hash(this.cardNumber, this.account, this.payee, this.instructedAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConfirmationOfFunds {\n");
        sb.append("    cardNumber: ").append(this.toIndentedString(this.cardNumber)).append("\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    payee: ").append(this.toIndentedString(this.payee)).append("\n");
        sb.append("    instructedAmount: ").append(this.toIndentedString(this.instructedAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

