/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="It is contained in addition to the data element 'chosenScaMethod' if challenge data is needed for SCA. In rare cases this attribute is also used in the context of the 'startAuthorisationWithPsuAuthentication' link. ")
@Validated
public class ChallengeData {
    @JsonProperty(value="image")
    private byte[] image = null;
    @JsonProperty(value="data")
    private String data = null;
    @JsonProperty(value="imageLink")
    private String imageLink = null;
    @JsonProperty(value="otpMaxLength")
    private Integer otpMaxLength = null;
    @JsonProperty(value="otpFormat")
    private OtpFormatEnum otpFormat = null;
    @JsonProperty(value="additionalInformation")
    private String additionalInformation = null;

    public ChallengeData image(byte[] image) {
        this.image = image;
        return this;
    }

    @ApiModelProperty(value="PNG data (max. 512 kilobyte) to be displayed to the PSU, Base64 encoding, cp. [RFC4648]. This attribute is used only, when PHOTO_OTP or CHIP_OTP is the selected SCA method. ")
    public byte[] getImage() {
        return this.image;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    public ChallengeData data(String data) {
        this.data = data;
        return this;
    }

    @ApiModelProperty(value="String challenge data")
    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public ChallengeData imageLink(String imageLink) {
        this.imageLink = imageLink;
        return this;
    }

    @ApiModelProperty(value="A link where the ASPSP will provides the challenge image for the TPP.")
    public String getImageLink() {
        return this.imageLink;
    }

    public void setImageLink(String imageLink) {
        this.imageLink = imageLink;
    }

    public ChallengeData otpMaxLength(Integer otpMaxLength) {
        this.otpMaxLength = otpMaxLength;
        return this;
    }

    @ApiModelProperty(value="The maximal length for the OTP to be typed in by the PSU.")
    public Integer getOtpMaxLength() {
        return this.otpMaxLength;
    }

    public void setOtpMaxLength(Integer otpMaxLength) {
        this.otpMaxLength = otpMaxLength;
    }

    public ChallengeData otpFormat(OtpFormatEnum otpFormat) {
        this.otpFormat = otpFormat;
        return this;
    }

    @ApiModelProperty(value="The format type of the OTP to be typed in. The admitted values are \"characters\" or \"integer\".")
    public OtpFormatEnum getOtpFormat() {
        return this.otpFormat;
    }

    public void setOtpFormat(OtpFormatEnum otpFormat) {
        this.otpFormat = otpFormat;
    }

    public ChallengeData additionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
        return this;
    }

    @ApiModelProperty(value="Additional explanation for the PSU to explain e.g. fallback mechanism for the chosen SCA method. The TPP is obliged to show this to the PSU. ")
    public String getAdditionalInformation() {
        return this.additionalInformation;
    }

    public void setAdditionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChallengeData challengeData = (ChallengeData)o;
        return Objects.equals(this.image, challengeData.image) && Objects.equals(this.data, challengeData.data) && Objects.equals(this.imageLink, challengeData.imageLink) && Objects.equals(this.otpMaxLength, challengeData.otpMaxLength) && Objects.equals((Object)this.otpFormat, (Object)challengeData.otpFormat) && Objects.equals(this.additionalInformation, challengeData.additionalInformation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.image, this.data, this.imageLink, this.otpMaxLength, this.otpFormat, this.additionalInformation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChallengeData {\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    imageLink: ").append(this.toIndentedString(this.imageLink)).append("\n");
        sb.append("    otpMaxLength: ").append(this.toIndentedString(this.otpMaxLength)).append("\n");
        sb.append("    otpFormat: ").append(this.toIndentedString((Object)this.otpFormat)).append("\n");
        sb.append("    additionalInformation: ").append(this.toIndentedString(this.additionalInformation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OtpFormatEnum {
        CHARACTERS("characters"),
        INTEGER("integer");

        private String value;

        private OtpFormatEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OtpFormatEnum fromValue(String text) {
            for (OtpFormatEnum b : OtpFormatEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

