/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.PaymentInitiationTarget2Json;
import de.adorsys.psd2.model.TransactionStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="JSON response body consistion of the corresponding bulk TARGET-2 payment initation JSON body together with an optional transaction status field. ")
@Validated
public class BulkPaymentInitiationTarget2WithStatusResponse {
    @JsonProperty(value="batchBookingPreferred")
    private Boolean batchBookingPreferred = null;
    @JsonProperty(value="requestedExecutionDate")
    private LocalDate requestedExecutionDate = null;
    @JsonProperty(value="debtorAccount")
    private Object debtorAccount = null;
    @JsonProperty(value="payments")
    @Valid
    private List<PaymentInitiationTarget2Json> payments = new ArrayList<PaymentInitiationTarget2Json>();
    @JsonProperty(value="transactionStatus")
    private TransactionStatus transactionStatus = null;

    public BulkPaymentInitiationTarget2WithStatusResponse batchBookingPreferred(Boolean batchBookingPreferred) {
        this.batchBookingPreferred = batchBookingPreferred;
        return this;
    }

    @ApiModelProperty
    public Boolean getBatchBookingPreferred() {
        return this.batchBookingPreferred;
    }

    public void setBatchBookingPreferred(Boolean batchBookingPreferred) {
        this.batchBookingPreferred = batchBookingPreferred;
    }

    public BulkPaymentInitiationTarget2WithStatusResponse requestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
        return this;
    }

    @ApiModelProperty
    @Valid
    public LocalDate getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public BulkPaymentInitiationTarget2WithStatusResponse debtorAccount(Object debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(required=true)
    @NotNull
    public Object getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(Object debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public BulkPaymentInitiationTarget2WithStatusResponse payments(List<PaymentInitiationTarget2Json> payments) {
        this.payments = payments;
        return this;
    }

    public BulkPaymentInitiationTarget2WithStatusResponse addPaymentsItem(PaymentInitiationTarget2Json paymentsItem) {
        this.payments.add(paymentsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of JSON bodies for TARGET-2 payments.")
    @NotNull
    @Valid
    public List<PaymentInitiationTarget2Json> getPayments() {
        return this.payments;
    }

    public void setPayments(List<PaymentInitiationTarget2Json> payments) {
        this.payments = payments;
    }

    public BulkPaymentInitiationTarget2WithStatusResponse transactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
        return this;
    }

    @ApiModelProperty
    @Valid
    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkPaymentInitiationTarget2WithStatusResponse bulkPaymentInitiationTarget2WithStatusResponse = (BulkPaymentInitiationTarget2WithStatusResponse)o;
        return Objects.equals(this.batchBookingPreferred, bulkPaymentInitiationTarget2WithStatusResponse.batchBookingPreferred) && Objects.equals(this.requestedExecutionDate, bulkPaymentInitiationTarget2WithStatusResponse.requestedExecutionDate) && Objects.equals(this.debtorAccount, bulkPaymentInitiationTarget2WithStatusResponse.debtorAccount) && Objects.equals(this.payments, bulkPaymentInitiationTarget2WithStatusResponse.payments) && Objects.equals((Object)this.transactionStatus, (Object)bulkPaymentInitiationTarget2WithStatusResponse.transactionStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.batchBookingPreferred, this.requestedExecutionDate, this.debtorAccount, this.payments, this.transactionStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkPaymentInitiationTarget2WithStatusResponse {\n");
        sb.append("    batchBookingPreferred: ").append(this.toIndentedString(this.batchBookingPreferred)).append("\n");
        sb.append("    requestedExecutionDate: ").append(this.toIndentedString(this.requestedExecutionDate)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("    transactionStatus: ").append(this.toIndentedString((Object)this.transactionStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

