/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.PaymentInitiationSctBulkElementJson;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="JSON Body for a bulk SCT payment initation. ")
@Validated
public class BulkPaymentInitiationSctJson {
    @JsonProperty(value="batchBookingPreferred")
    private Boolean batchBookingPreferred = null;
    @JsonProperty(value="requestedExecutionDate")
    private LocalDate requestedExecutionDate = null;
    @JsonProperty(value="debtorAccount")
    private Object debtorAccount = null;
    @JsonProperty(value="payments")
    @Valid
    private List<PaymentInitiationSctBulkElementJson> payments = new ArrayList<PaymentInitiationSctBulkElementJson>();

    public BulkPaymentInitiationSctJson batchBookingPreferred(Boolean batchBookingPreferred) {
        this.batchBookingPreferred = batchBookingPreferred;
        return this;
    }

    @ApiModelProperty
    public Boolean getBatchBookingPreferred() {
        return this.batchBookingPreferred;
    }

    public void setBatchBookingPreferred(Boolean batchBookingPreferred) {
        this.batchBookingPreferred = batchBookingPreferred;
    }

    public BulkPaymentInitiationSctJson requestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
        return this;
    }

    @ApiModelProperty
    @Valid
    public LocalDate getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public BulkPaymentInitiationSctJson debtorAccount(Object debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(required=true)
    @NotNull
    public Object getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(Object debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public BulkPaymentInitiationSctJson payments(List<PaymentInitiationSctBulkElementJson> payments) {
        this.payments = payments;
        return this;
    }

    public BulkPaymentInitiationSctJson addPaymentsItem(PaymentInitiationSctBulkElementJson paymentsItem) {
        this.payments.add(paymentsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of JSON bodies for SCT payments.")
    @NotNull
    @Valid
    public List<PaymentInitiationSctBulkElementJson> getPayments() {
        return this.payments;
    }

    public void setPayments(List<PaymentInitiationSctBulkElementJson> payments) {
        this.payments = payments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkPaymentInitiationSctJson bulkPaymentInitiationSctJson = (BulkPaymentInitiationSctJson)o;
        return Objects.equals(this.batchBookingPreferred, bulkPaymentInitiationSctJson.batchBookingPreferred) && Objects.equals(this.requestedExecutionDate, bulkPaymentInitiationSctJson.requestedExecutionDate) && Objects.equals(this.debtorAccount, bulkPaymentInitiationSctJson.debtorAccount) && Objects.equals(this.payments, bulkPaymentInitiationSctJson.payments);
    }

    public int hashCode() {
        return Objects.hash(this.batchBookingPreferred, this.requestedExecutionDate, this.debtorAccount, this.payments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkPaymentInitiationSctJson {\n");
        sb.append("    batchBookingPreferred: ").append(this.toIndentedString(this.batchBookingPreferred)).append("\n");
        sb.append("    requestedExecutionDate: ").append(this.toIndentedString(this.requestedExecutionDate)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

