/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.PaymentInitiationSctInstJson;
import de.adorsys.psd2.model.TransactionStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="JSON response body consistion of the corresponding bulk SCT INST payment initation JSON body together with an optional transaction status field. ")
@Validated
public class BulkPaymentInitiationSctInstWithStatusResponse {
    @JsonProperty(value="batchBookingPreferred")
    private Boolean batchBookingPreferred = null;
    @JsonProperty(value="requestedExecutionDate")
    private LocalDate requestedExecutionDate = null;
    @JsonProperty(value="debtorAccount")
    private Object debtorAccount = null;
    @JsonProperty(value="payments")
    @Valid
    private List<PaymentInitiationSctInstJson> payments = new ArrayList<PaymentInitiationSctInstJson>();
    @JsonProperty(value="transactionStatus")
    private TransactionStatus transactionStatus = null;

    public BulkPaymentInitiationSctInstWithStatusResponse batchBookingPreferred(Boolean batchBookingPreferred) {
        this.batchBookingPreferred = batchBookingPreferred;
        return this;
    }

    @ApiModelProperty
    public Boolean getBatchBookingPreferred() {
        return this.batchBookingPreferred;
    }

    public void setBatchBookingPreferred(Boolean batchBookingPreferred) {
        this.batchBookingPreferred = batchBookingPreferred;
    }

    public BulkPaymentInitiationSctInstWithStatusResponse requestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
        return this;
    }

    @ApiModelProperty
    @Valid
    public LocalDate getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public BulkPaymentInitiationSctInstWithStatusResponse debtorAccount(Object debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(required=true)
    @NotNull
    public Object getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(Object debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public BulkPaymentInitiationSctInstWithStatusResponse payments(List<PaymentInitiationSctInstJson> payments) {
        this.payments = payments;
        return this;
    }

    public BulkPaymentInitiationSctInstWithStatusResponse addPaymentsItem(PaymentInitiationSctInstJson paymentsItem) {
        this.payments.add(paymentsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of JSON bodies for SCT INST payments.")
    @NotNull
    @Valid
    public List<PaymentInitiationSctInstJson> getPayments() {
        return this.payments;
    }

    public void setPayments(List<PaymentInitiationSctInstJson> payments) {
        this.payments = payments;
    }

    public BulkPaymentInitiationSctInstWithStatusResponse transactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
        return this;
    }

    @ApiModelProperty
    @Valid
    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkPaymentInitiationSctInstWithStatusResponse bulkPaymentInitiationSctInstWithStatusResponse = (BulkPaymentInitiationSctInstWithStatusResponse)o;
        return Objects.equals(this.batchBookingPreferred, bulkPaymentInitiationSctInstWithStatusResponse.batchBookingPreferred) && Objects.equals(this.requestedExecutionDate, bulkPaymentInitiationSctInstWithStatusResponse.requestedExecutionDate) && Objects.equals(this.debtorAccount, bulkPaymentInitiationSctInstWithStatusResponse.debtorAccount) && Objects.equals(this.payments, bulkPaymentInitiationSctInstWithStatusResponse.payments) && Objects.equals((Object)this.transactionStatus, (Object)bulkPaymentInitiationSctInstWithStatusResponse.transactionStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.batchBookingPreferred, this.requestedExecutionDate, this.debtorAccount, this.payments, this.transactionStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkPaymentInitiationSctInstWithStatusResponse {\n");
        sb.append("    batchBookingPreferred: ").append(this.toIndentedString(this.batchBookingPreferred)).append("\n");
        sb.append("    requestedExecutionDate: ").append(this.toIndentedString(this.requestedExecutionDate)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("    transactionStatus: ").append(this.toIndentedString((Object)this.transactionStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

