/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.PaymentInitiationCrossBorderJson;
import de.adorsys.psd2.model.TransactionStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="JSON response body consistion of the corresponding bulk cross-border payment initation JSON body together with an optional transaction status field. ")
@Validated
public class BulkPaymentInitiationCrossBorderWithStatusResponse {
    @JsonProperty(value="batchBookingPreferred")
    private Boolean batchBookingPreferred = null;
    @JsonProperty(value="requestedExecutionDate")
    private LocalDate requestedExecutionDate = null;
    @JsonProperty(value="debtorAccount")
    private Object debtorAccount = null;
    @JsonProperty(value="payments")
    @Valid
    private List<PaymentInitiationCrossBorderJson> payments = new ArrayList<PaymentInitiationCrossBorderJson>();
    @JsonProperty(value="transactionStatus")
    private TransactionStatus transactionStatus = null;

    public BulkPaymentInitiationCrossBorderWithStatusResponse batchBookingPreferred(Boolean batchBookingPreferred) {
        this.batchBookingPreferred = batchBookingPreferred;
        return this;
    }

    @ApiModelProperty
    public Boolean getBatchBookingPreferred() {
        return this.batchBookingPreferred;
    }

    public void setBatchBookingPreferred(Boolean batchBookingPreferred) {
        this.batchBookingPreferred = batchBookingPreferred;
    }

    public BulkPaymentInitiationCrossBorderWithStatusResponse requestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
        return this;
    }

    @ApiModelProperty
    @Valid
    public LocalDate getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public BulkPaymentInitiationCrossBorderWithStatusResponse debtorAccount(Object debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(required=true)
    @NotNull
    public Object getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(Object debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public BulkPaymentInitiationCrossBorderWithStatusResponse payments(List<PaymentInitiationCrossBorderJson> payments) {
        this.payments = payments;
        return this;
    }

    public BulkPaymentInitiationCrossBorderWithStatusResponse addPaymentsItem(PaymentInitiationCrossBorderJson paymentsItem) {
        this.payments.add(paymentsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of JSON bodies for cross-border payments.")
    @NotNull
    @Valid
    public List<PaymentInitiationCrossBorderJson> getPayments() {
        return this.payments;
    }

    public void setPayments(List<PaymentInitiationCrossBorderJson> payments) {
        this.payments = payments;
    }

    public BulkPaymentInitiationCrossBorderWithStatusResponse transactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
        return this;
    }

    @ApiModelProperty
    @Valid
    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkPaymentInitiationCrossBorderWithStatusResponse bulkPaymentInitiationCrossBorderWithStatusResponse = (BulkPaymentInitiationCrossBorderWithStatusResponse)o;
        return Objects.equals(this.batchBookingPreferred, bulkPaymentInitiationCrossBorderWithStatusResponse.batchBookingPreferred) && Objects.equals(this.requestedExecutionDate, bulkPaymentInitiationCrossBorderWithStatusResponse.requestedExecutionDate) && Objects.equals(this.debtorAccount, bulkPaymentInitiationCrossBorderWithStatusResponse.debtorAccount) && Objects.equals(this.payments, bulkPaymentInitiationCrossBorderWithStatusResponse.payments) && Objects.equals((Object)this.transactionStatus, (Object)bulkPaymentInitiationCrossBorderWithStatusResponse.transactionStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.batchBookingPreferred, this.requestedExecutionDate, this.debtorAccount, this.payments, this.transactionStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkPaymentInitiationCrossBorderWithStatusResponse {\n");
        sb.append("    batchBookingPreferred: ").append(this.toIndentedString(this.batchBookingPreferred)).append("\n");
        sb.append("    requestedExecutionDate: ").append(this.toIndentedString(this.requestedExecutionDate)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("    transactionStatus: ").append(this.toIndentedString((Object)this.transactionStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

