/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.PaymentInitiationCrossBorderBulkElementJson;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="JSON body for a bulk cross-border payment initation. ")
@Validated
public class BulkPaymentInitiationCrossBorderJson {
    @JsonProperty(value="batchBookingPreferred")
    private Boolean batchBookingPreferred = null;
    @JsonProperty(value="requestedExecutionDate")
    private LocalDate requestedExecutionDate = null;
    @JsonProperty(value="debtorAccount")
    private Object debtorAccount = null;
    @JsonProperty(value="payments")
    @Valid
    private List<PaymentInitiationCrossBorderBulkElementJson> payments = new ArrayList<PaymentInitiationCrossBorderBulkElementJson>();

    public BulkPaymentInitiationCrossBorderJson batchBookingPreferred(Boolean batchBookingPreferred) {
        this.batchBookingPreferred = batchBookingPreferred;
        return this;
    }

    @ApiModelProperty
    public Boolean getBatchBookingPreferred() {
        return this.batchBookingPreferred;
    }

    public void setBatchBookingPreferred(Boolean batchBookingPreferred) {
        this.batchBookingPreferred = batchBookingPreferred;
    }

    public BulkPaymentInitiationCrossBorderJson requestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
        return this;
    }

    @ApiModelProperty
    @Valid
    public LocalDate getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public BulkPaymentInitiationCrossBorderJson debtorAccount(Object debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(required=true)
    @NotNull
    public Object getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(Object debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public BulkPaymentInitiationCrossBorderJson payments(List<PaymentInitiationCrossBorderBulkElementJson> payments) {
        this.payments = payments;
        return this;
    }

    public BulkPaymentInitiationCrossBorderJson addPaymentsItem(PaymentInitiationCrossBorderBulkElementJson paymentsItem) {
        this.payments.add(paymentsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A List of JSON bodies for cross-border payments.")
    @NotNull
    @Valid
    public List<PaymentInitiationCrossBorderBulkElementJson> getPayments() {
        return this.payments;
    }

    public void setPayments(List<PaymentInitiationCrossBorderBulkElementJson> payments) {
        this.payments = payments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkPaymentInitiationCrossBorderJson bulkPaymentInitiationCrossBorderJson = (BulkPaymentInitiationCrossBorderJson)o;
        return Objects.equals(this.batchBookingPreferred, bulkPaymentInitiationCrossBorderJson.batchBookingPreferred) && Objects.equals(this.requestedExecutionDate, bulkPaymentInitiationCrossBorderJson.requestedExecutionDate) && Objects.equals(this.debtorAccount, bulkPaymentInitiationCrossBorderJson.debtorAccount) && Objects.equals(this.payments, bulkPaymentInitiationCrossBorderJson.payments);
    }

    public int hashCode() {
        return Objects.hash(this.batchBookingPreferred, this.requestedExecutionDate, this.debtorAccount, this.payments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkPaymentInitiationCrossBorderJson {\n");
        sb.append("    batchBookingPreferred: ").append(this.toIndentedString(this.batchBookingPreferred)).append("\n");
        sb.append("    requestedExecutionDate: ").append(this.toIndentedString(this.requestedExecutionDate)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

