/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.model.ConfirmationOfFunds;
import de.adorsys.psd2.model.InlineResponse200;
import de.adorsys.psd2.model.TppMessages400;
import de.adorsys.psd2.model.TppMessages401;
import de.adorsys.psd2.model.TppMessages403;
import de.adorsys.psd2.model.TppMessages404;
import de.adorsys.psd2.model.TppMessages405;
import de.adorsys.psd2.model.TppMessages406;
import de.adorsys.psd2.model.TppMessages429;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value="v1", description="funds confirmation API")
public interface FundsConfirmationApi {
    public static final Logger log = LoggerFactory.getLogger(FundsConfirmationApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value="Confirmation of Funds Request", nickname="checkAvailabilityOfFunds", notes="Creates a confirmation of funds request at the ASPSP. Checks whether a specific amount is available at point of time of the request on an account linked to a given tuple card issuer(TPP)/card number, or addressed by IBAN and TPP respectively", response=InlineResponse200.class, tags={"Confirmation of Funds Service"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=InlineResponse200.class), @ApiResponse(code=400, message="Bad Request", response=TppMessages400.class), @ApiResponse(code=401, message="Unauthorized", response=TppMessages401.class), @ApiResponse(code=403, message="Forbidden", response=TppMessages403.class), @ApiResponse(code=404, message="Not found", response=TppMessages404.class), @ApiResponse(code=405, message="Method Not Allowed", response=TppMessages405.class), @ApiResponse(code=406, message="Not Acceptable", response=TppMessages406.class), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests", response=TppMessages429.class), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/funds-confirmations"}, produces={"application/json"}, method={RequestMethod.POST})
    default public ResponseEntity<?> _checkAvailabilityOfFunds(@ApiParam(value="Request body for a confirmation of funds request. ", required=true) @Valid @RequestBody ConfirmationOfFunds body, @ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate) {
        return this.checkAvailabilityOfFunds(body, xRequestID, digest, signature, tpPSignatureCertificate);
    }

    default public ResponseEntity<?> checkAvailabilityOfFunds(ConfirmationOfFunds body, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default V1Api interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

