/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web12;

import de.adorsys.aspsp.xs2a.service.FundsConfirmationService;
import de.adorsys.aspsp.xs2a.service.mapper.FundsConfirmationModelMapper;
import de.adorsys.aspsp.xs2a.service.mapper.ResponseMapper;
import de.adorsys.psd2.api.FundsConfirmationApi;
import de.adorsys.psd2.model.ConfirmationOfFunds;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"PIISP, Funds confirmation 1.2"}, description="Provides access to the funds confirmation")
public class FundsConfirmationController12
implements FundsConfirmationApi {
    private static final Logger log = LoggerFactory.getLogger(FundsConfirmationController12.class);
    private final ResponseMapper responseMapper;
    private final FundsConfirmationService fundsConfirmationService;

    public ResponseEntity<?> checkAvailabilityOfFunds(ConfirmationOfFunds body, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate) {
        return this.responseMapper.ok(this.fundsConfirmationService.fundsConfirmation(FundsConfirmationModelMapper.mapToFundsConfirmationRequest(body)));
    }

    @ConstructorProperties(value={"responseMapper", "fundsConfirmationService"})
    public FundsConfirmationController12(ResponseMapper responseMapper, FundsConfirmationService fundsConfirmationService) {
        this.responseMapper = responseMapper;
        this.fundsConfirmationService = fundsConfirmationService;
    }
}

