/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web12;

import de.adorsys.aspsp.xs2a.domain.ResponseObject;
import de.adorsys.aspsp.xs2a.domain.account.AccountReference;
import de.adorsys.aspsp.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.aspsp.xs2a.service.AccountReferenceValidationService;
import de.adorsys.aspsp.xs2a.service.ConsentService;
import de.adorsys.aspsp.xs2a.service.mapper.ConsentModelMapper;
import de.adorsys.aspsp.xs2a.service.mapper.ResponseMapper;
import de.adorsys.psd2.api.ConsentApi;
import de.adorsys.psd2.model.Consents;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"AISP, Consents version 1.2"}, description="Provides access to the Psu Consents")
public class ConsentController12
implements ConsentApi {
    private static final Logger log = LoggerFactory.getLogger(ConsentController12.class);
    private final ConsentService consentService;
    private final ResponseMapper responseMapper;
    private final AccountReferenceValidationService referenceValidationService;

    public ResponseEntity<?> createConsent(UUID xRequestID, Consents body, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, Boolean tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, Boolean tpPExplicitAuthorisationPreferred, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        CreateConsentReq createConsent = ConsentModelMapper.mapToCreateConsentReq(body);
        Set<AccountReference> references = createConsent.getAccountReferences();
        ResponseObject accountReferenceValidationResponse = references.isEmpty() ? ResponseObject.builder().build() : this.referenceValidationService.validateAccountReferences(createConsent.getAccountReferences());
        ResponseObject<Object> createConsentResponse = accountReferenceValidationResponse.hasError() ? ResponseObject.builder().fail(accountReferenceValidationResponse.getError()).build() : this.consentService.createAccountConsentsWithResponse(createConsent, PSU_ID);
        return this.responseMapper.created(createConsentResponse, ConsentModelMapper::mapToConsentsResponse201);
    }

    public ResponseEntity<?> getConsentStatus(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        return this.responseMapper.ok(this.consentService.getAccountConsentsStatusById(consentId), ConsentModelMapper::mapToConsentStatusResponse200);
    }

    public ResponseEntity<?> getConsentInformation(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        return this.responseMapper.ok(this.consentService.getAccountConsentById(consentId), ConsentModelMapper::mapToConsentInformationResponse200Json);
    }

    public ResponseEntity<?> deleteConsent(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Void> response = this.consentService.deleteAccountConsentsById(consentId);
        return this.responseMapper.delete(response);
    }

    @ConstructorProperties(value={"consentService", "responseMapper", "referenceValidationService"})
    public ConsentController12(ConsentService consentService, ResponseMapper responseMapper, AccountReferenceValidationService referenceValidationService) {
        this.consentService = consentService;
        this.responseMapper = responseMapper;
        this.referenceValidationService = referenceValidationService;
    }
}

