/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web.interceptor;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.domain.TppMessageInformation;
import de.adorsys.aspsp.xs2a.domain.TransactionStatus;
import de.adorsys.aspsp.xs2a.exception.MessageCategory;
import de.adorsys.aspsp.xs2a.exception.MessageError;
import de.adorsys.aspsp.xs2a.service.validator.RequestValidatorService;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class HandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(HandlerInterceptor.class);
    private final RequestValidatorService requestValidatorService;
    private final ObjectMapper objectMapper;
    private final MessageSource messageSource;

    @Autowired
    public HandlerInterceptor(RequestValidatorService requestValidatorService, ObjectMapper objectMapper, MessageSource messageSource) {
        this.requestValidatorService = requestValidatorService;
        this.objectMapper = objectMapper;
        this.messageSource = messageSource;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        return this.isRequestValidAndSendRespIfError(request, response, handler);
    }

    private boolean isRequestValidAndSendRespIfError(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        Map<String, String> violationsMap = this.requestValidatorService.getRequestViolationMap(request, handler);
        if (violationsMap.isEmpty()) {
            return true;
        }
        Map.Entry<String, String> firstError = violationsMap.entrySet().iterator().next();
        MessageErrorCode messageCode = this.getActualMessageErrorCode(firstError.getKey());
        log.debug("Handled error {}", (Object)(messageCode.name() + ": " + firstError.getValue()));
        response.resetBuffer();
        response.setStatus(messageCode.getCode());
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Type", "application/json");
        response.getWriter().write(this.objectMapper.writeValueAsString((Object)this.getMessageError(messageCode)));
        response.flushBuffer();
        return false;
    }

    private MessageErrorCode getActualMessageErrorCode(String error) {
        return MessageErrorCode.getByName(error).orElse(MessageErrorCode.FORMAT_ERROR);
    }

    private MessageError getMessageError(MessageErrorCode errorCode) {
        String message = this.messageSource.getMessage(errorCode.name(), null, Locale.forLanguageTag("en"));
        TppMessageInformation messageInformation = new TppMessageInformation(MessageCategory.ERROR, errorCode);
        messageInformation.setText(message);
        return new MessageError(TransactionStatus.RJCT, messageInformation);
    }
}

