/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web.aspect;

import de.adorsys.aspsp.xs2a.domain.ResponseObject;
import de.adorsys.aspsp.xs2a.domain.TppMessageInformation;
import de.adorsys.aspsp.xs2a.exception.MessageError;
import de.adorsys.aspsp.xs2a.service.message.MessageService;
import java.beans.ConstructorProperties;
import java.util.Collections;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class FailResponseAspect {
    private final MessageService messageService;

    @AfterReturning(pointcut="execution(public * de.adorsys.aspsp.xs2a.service.*.*(..))", returning="result")
    public Object invokeAspect(Object result) {
        return result instanceof ResponseObject ? this.enrichResponseObject(result) : result;
    }

    private ResponseObject enrichResponseObject(Object result) {
        ResponseObject response = (ResponseObject)result;
        return response.hasError() ? this.doEnrich(response) : response;
    }

    private ResponseObject doEnrich(ResponseObject response) {
        MessageError error = response.getError();
        TppMessageInformation tppMessage = error.getTppMessage();
        tppMessage.setText(this.messageService.getMessage(tppMessage.getMessageErrorCode().name()));
        error.setTppMessages(Collections.singleton(tppMessage));
        return ResponseObject.builder().fail(error).build();
    }

    @ConstructorProperties(value={"messageService"})
    public FailResponseAspect(MessageService messageService) {
        this.messageService = messageService;
    }
}

