/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web.aspect;

import de.adorsys.aspsp.xs2a.domain.Links;
import de.adorsys.aspsp.xs2a.domain.consent.CreateConsentResponse;
import de.adorsys.aspsp.xs2a.web.ConsentInformationController;
import de.adorsys.aspsp.xs2a.web.aspect.AbstractLinkAspect;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Aspect
@Component
public class ConsentAspect
extends AbstractLinkAspect<ConsentInformationController> {
    private static final Logger log = LoggerFactory.getLogger(ConsentAspect.class);

    @AfterReturning(pointcut="execution(* de.adorsys.aspsp.xs2a.web.ConsentInformationController.createAccountConsent(..)) && args(psuId, ..)", returning="result")
    public ResponseEntity<CreateConsentResponse> invokeCreateAccountConsentAspect(ResponseEntity<CreateConsentResponse> result, String psuId) {
        if (!this.hasError(result)) {
            CreateConsentResponse body = (CreateConsentResponse)result.getBody();
            body.setLinks(this.buildLinksForConsentResponse(body));
        }
        return new ResponseEntity(result.getBody(), (MultiValueMap)result.getHeaders(), result.getStatusCode());
    }

    private Links buildLinksForConsentResponse(CreateConsentResponse response) {
        Links links = new Links();
        links.setScaRedirect(this.aspspProfileService.getAisRedirectUrlToAspsp() + response.getConsentId());
        return links;
    }
}

