/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web;

import de.adorsys.aspsp.xs2a.domain.ResponseObject;
import de.adorsys.aspsp.xs2a.domain.TransactionStatus;
import de.adorsys.aspsp.xs2a.domain.TransactionStatusResponse;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentType;
import de.adorsys.aspsp.xs2a.domain.pis.SinglePayment;
import de.adorsys.aspsp.xs2a.service.AccountReferenceValidationService;
import de.adorsys.aspsp.xs2a.service.PaymentService;
import de.adorsys.aspsp.xs2a.service.mapper.ResponseMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.beans.ConstructorProperties;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"api/v1/payments/{payment-product}"})
@Api(value="api/v1/payments/{payment-product}", tags={"PISP, Payments"}, description="Provides access to the PIS")
public class PaymentInitiationController {
    private static final Logger log = LoggerFactory.getLogger(PaymentInitiationController.class);
    private static final String TPP_INFO = "eyJuYXRpb25hbENvbXBldGVudEF1dGhvcml0eSI6ICJOYXRpb25hbCBjb21wZXRlbnQgYXV0aG9yaXR5IiwKICAgICJub2tSZWRpcmVjdFVyaSI6ICJOb2sgcmVkaXJlY3QgVVJJIiwKICAgICJyZWRpcmVjdFVyaSI6ICJSZWRpcmVjdCBVUkkiLAogICAgInJlZ2lzdHJhdGlvbk51bWJlciI6ICIxMjM0X3JlZ2lzdHJhdGlvbk51bWJlciIsCiAgICAidHBwTmFtZSI6ICJUcHAgY29tcGFueSIsCiAgICAidHBwUm9sZSI6ICJUcHAgcm9sZSIKICB9";
    private final ResponseMapper responseMapper;
    private final PaymentService paymentService;
    private final AccountReferenceValidationService referenceValidationService;

    @ApiOperation(value="Initialises a new payment ", notes="debtor account, creditor accout, creditor name, remittance information unstructured", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=201, message="Created"), @ApiResponse(code=400, message="Bad request")})
    @PostMapping
    @ApiImplicitParams(value={@ApiImplicitParam(name="x-request-id", value="2f77a125-aa7a-45c0-b414-cea25a116035", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="psu-ip-address", value="192.168.8.78", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="date", value="Sun, 11 Aug 2019 15:02:37 GMT", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="psu-id", value="12312324", dataType="String", paramType="header"), @ApiImplicitParam(name="psu-id-type", value="Type of the PSU-ID", dataType="String", paramType="header"), @ApiImplicitParam(name="psu-corporate-id", value="Might be mandated in the ASPSP\u2019s documentation", dataType="String", paramType="header"), @ApiImplicitParam(name="psu-corporate-id-type", value="Might be mandated in the ASPSP\u2019s documentation", dataType="String", paramType="header"), @ApiImplicitParam(name="psu-consent-id", value="This data element may be contained, if the payment initiation transaction is part of a session, i.e. combined AIS/PIS service", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="psu-agent", value="The forwarded Agent header field of the http request between PSU and TPP.", dataType="String", paramType="header"), @ApiImplicitParam(name="psu-geo-location", value="GEO:52.506931,13.1445588", dataType="Geo Location", paramType="header"), @ApiImplicitParam(name="tpp-redirect-uri", value="Uri of TPP", dataType="String", paramType="header"), @ApiImplicitParam(name="digest", value="730f75dafd73e047b86acb2dbd74e75dcb93272fa084a9082848f2341aa1abb6", dataType="String", paramType="header"), @ApiImplicitParam(name="signature", value="A signature of the request by TPP", dataType="String", paramType="header"), @ApiImplicitParam(name="tpp-signature-certificate", value="some certificate", dataType="String", paramType="header"), @ApiImplicitParam(name="tpp-qwac-certificate", value="qwac certificate", required=true, dataType="String", paramType="header")})
    public ResponseEntity<PaymentInitialisationResponse> createPaymentInitiation(@ApiParam(name="payment-product", value="The addressed payment product endpoint for payments e.g. for a SEPA Credit Transfers", allowableValues="sepa-credit-transfers, target-2-payments,instant-sepa-credit-transfers, cross-border-credit-transfers") @PathVariable(value="payment-product") String paymentProduct, @RequestHeader(name="tpp-signature-certificate", required=false) String tppSignatureCertificate, @ApiParam(name="singlePayment", required=true) @RequestBody @Valid SinglePayment singlePayment) {
        ResponseObject accountReferenceValidationResponse = this.referenceValidationService.validateAccountReferences(singlePayment.getAccountReferences());
        ResponseObject<Object> response = accountReferenceValidationResponse.hasError() ? ResponseObject.builder().fail(accountReferenceValidationResponse.getError()).build() : this.paymentService.createPaymentInitiation(singlePayment, tppSignatureCertificate, paymentProduct);
        return this.responseMapper.created(response);
    }

    @ApiOperation(value="Get information  about the status of a payment initialisation ", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=TransactionStatus.class), @ApiResponse(code=403, message="Not found")})
    @GetMapping(path={"/{paymentId}/status"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="x-request-id", value="2f77a125-aa7a-45c0-b414-cea25a116035", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="date", value="Sun, 11 Aug 2019 15:02:37 GMT", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="digest", value="730f75dafd73e047b86acb2dbd74e75dcb93272fa084a9082848f2341aa1abb6", dataType="String", paramType="header"), @ApiImplicitParam(name="signature", value="98c0", dataType="String", paramType="header"), @ApiImplicitParam(name="tpp-signature-certificate", value="some certificate", dataType="String", paramType="header"), @ApiImplicitParam(name="tpp-qwac-certificate", value="qwac certificate", dataType="String", paramType="header")})
    public ResponseEntity<TransactionStatusResponse> getPaymentInitiationStatusById(@ApiParam(name="payment-product", value="The addressed payment product endpoint for payments e.g. for a SEPA Credit Transfers", allowableValues="sepa-credit-transfers, target-2-payments,instant-sepa-credit-transfers, cross-border-credit-transfers") @PathVariable(value="payment-product") String paymentProduct, @ApiParam(name="paymentId", value="529e0507-7539-4a65-9b74-bdf87061e99b") @PathVariable(value="paymentId") String paymentId) {
        ResponseObject<TransactionStatus> status = this.paymentService.getPaymentStatusById(paymentId, PaymentType.SINGLE);
        return this.responseMapper.ok(status.hasError() ? ResponseObject.builder().fail(status.getError()).build() : ResponseObject.builder().body(new TransactionStatusResponse(status.getBody())).build());
    }

    @ConstructorProperties(value={"responseMapper", "paymentService", "referenceValidationService"})
    public PaymentInitiationController(ResponseMapper responseMapper, PaymentService paymentService, AccountReferenceValidationService referenceValidationService) {
        this.responseMapper = responseMapper;
        this.paymentService = paymentService;
        this.referenceValidationService = referenceValidationService;
    }
}

