/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web;

import de.adorsys.aspsp.xs2a.domain.TransactionStatus;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentType;
import de.adorsys.aspsp.xs2a.service.PaymentService;
import de.adorsys.aspsp.xs2a.service.mapper.ResponseMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"api/v1/"})
@Api(value="api/v1/", tags={"PISP, Access to Payments"}, description="Provides access to the PIS payments")
public class PaymentController {
    private static final Logger log = LoggerFactory.getLogger(PaymentController.class);
    private final ResponseMapper responseMapper;
    private final PaymentService paymentService;

    @ApiOperation(value="Get payment information", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=TransactionStatus.class), @ApiResponse(code=404, message="Not found"), @ApiResponse(code=403, message="Wrong path variables")})
    @GetMapping(path={"/{payment-service}/{payment-product}/{paymentId}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="x-request-id", value="16d40f49-a110-4344-a949-f99828ae13c9", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="date", value="Sun, 11 Aug 2019 15:02:37 GMT", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="psu-id", value="2f77a125-aa7a-45c0-b414-cea25a116035", dataType="String", paramType="header"), @ApiImplicitParam(name="psu-ip-type", value="no data", dataType="String", paramType="header"), @ApiImplicitParam(name="signature", value="98c0", dataType="String", paramType="header"), @ApiImplicitParam(name="digest", value="730f75dafd73e047b86acb2dbd74e75dcb93272fa084a9082848f2341aa1abb6", dataType="String", paramType="header"), @ApiImplicitParam(name="tpp-signature-certificate", value="some certificate", dataType="String", paramType="header"), @ApiImplicitParam(name="tpp-qwac-certificate", value="qwac certificate", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="digest", value="digest of the payload request", dataType="String", paramType="header"), @ApiImplicitParam(name="psu-ip-address", value="192.168.0.26", required=true, dataType="String", paramType="header")})
    public ResponseEntity getPaymentById(@ApiParam(name="payment-service", value="The addressed payment service", required=true, allowableValues="payments, bulk-payments,periodic-payments") @PathVariable(value="payment-service") PaymentType paymentType, @ApiParam(name="payment-product", value="The addressed payment product ", required=true, allowableValues="sepa-credit-transfers, target-2-payments, instant-sepa-credit-transfers, cross-border-credit-transfers") @PathVariable(value="payment-product") String paymentProduct, @ApiParam(name="paymentId", value="529e0507-7539-4a65-9b74-bdf87061e99b", required=true) @PathVariable(value="paymentId") String paymentId) {
        return this.responseMapper.ok(this.paymentService.getPaymentById(paymentType, paymentId));
    }

    @ConstructorProperties(value={"responseMapper", "paymentService"})
    public PaymentController(ResponseMapper responseMapper, PaymentService paymentService) {
        this.responseMapper = responseMapper;
        this.paymentService = paymentService;
    }
}

