/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web;

import de.adorsys.aspsp.xs2a.domain.fund.FundsConfirmationRequest;
import de.adorsys.aspsp.xs2a.domain.fund.FundsConfirmationResponse;
import de.adorsys.aspsp.xs2a.service.AccountReferenceValidationService;
import de.adorsys.aspsp.xs2a.service.FundsConfirmationService;
import de.adorsys.aspsp.xs2a.service.mapper.ResponseMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.beans.ConstructorProperties;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"api/v1/funds-confirmations"})
@Api(value="api/v1/funds-confirmations", tags={"PIISP, Funds confirmation"}, description="Provides access to the funds confirmation")
public class FundsConfirmationController {
    private static final Logger log = LoggerFactory.getLogger(FundsConfirmationController.class);
    private final FundsConfirmationService fundsConfirmationService;
    private final ResponseMapper responseMapper;
    private final AccountReferenceValidationService referenceValidationService;

    @PostMapping
    @ApiOperation(value="Create a confirmation of funds request ", notes="debtor account, creditor account, creditor name, remittance information unstructured", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="return true or false"), @ApiResponse(code=400, message="Bad request")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="x-request-id", value="2f77a125-aa7a-45c0-b414-cea25a116035", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="date", value="Sun, 11 Aug 2019 15:02:37 GMT", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="digest", value="730f75dafd73e047b86acb2dbd74e75dcb93272fa084a9082848f2341aa1abb6", dataType="String", paramType="header"), @ApiImplicitParam(name="signature", value="98c0", dataType="String", paramType="header"), @ApiImplicitParam(name="tpp-signature-certificate", value="some certificate", dataType="String", paramType="header"), @ApiImplicitParam(name="tpp-qwac-certificate", value="qwac certificate", required=true, dataType="String", paramType="header")})
    public ResponseEntity<FundsConfirmationResponse> fundConfirmation(@RequestBody @Valid FundsConfirmationRequest request) {
        return this.responseMapper.ok(this.fundsConfirmationService.fundsConfirmation(request));
    }

    @ConstructorProperties(value={"fundsConfirmationService", "responseMapper", "referenceValidationService"})
    public FundsConfirmationController(FundsConfirmationService fundsConfirmationService, ResponseMapper responseMapper, AccountReferenceValidationService referenceValidationService) {
        this.fundsConfirmationService = fundsConfirmationService;
        this.responseMapper = responseMapper;
        this.referenceValidationService = referenceValidationService;
    }
}

