/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web;

import de.adorsys.aspsp.xs2a.domain.ResponseObject;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.domain.pis.SinglePayment;
import de.adorsys.aspsp.xs2a.service.AccountReferenceValidationService;
import de.adorsys.aspsp.xs2a.service.PaymentService;
import de.adorsys.aspsp.xs2a.service.mapper.ResponseMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.beans.ConstructorProperties;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"api/v1/bulk-payments/{payment-product}"})
@Api(value="api/v1/consents", tags={"PISP, Bulk payment initiation"}, description="Payment Initiation for Bulk Payments and Multiple Payments")
public class BulkPaymentInitiationController {
    private static final String TPP_INFO = "eyJuYXRpb25hbENvbXBldGVudEF1dGhvcml0eSI6ICJOYXRpb25hbCBjb21wZXRlbnQgYXV0aG9yaXR5IiwKICAgICJub2tSZWRpcmVjdFVyaSI6ICJOb2sgcmVkaXJlY3QgVVJJIiwKICAgICJyZWRpcmVjdFVyaSI6ICJSZWRpcmVjdCBVUkkiLAogICAgInJlZ2lzdHJhdGlvbk51bWJlciI6ICIxMjM0X3JlZ2lzdHJhdGlvbk51bWJlciIsCiAgICAidHBwTmFtZSI6ICJUcHAgY29tcGFueSIsCiAgICAidHBwUm9sZSI6ICJUcHAgcm9sZSIKICB9";
    private final ResponseMapper responseMapper;
    private final PaymentService paymentService;
    private final AccountReferenceValidationService referenceValidationService;

    @ApiOperation(value="Creates a bulk payment initiation request at the ASPSP", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=201, message="transactions_status received, a list of hyperlinks to be recognized by the Tpp."), @ApiResponse(code=400, message="Bad request")})
    @PostMapping
    @ApiImplicitParams(value={@ApiImplicitParam(name="psu-ip-address", value="192.168.0.26", required=true, paramType="header"), @ApiImplicitParam(name="x-request-id", value="2f77a125-aa7a-45c0-b414-cea25a116035", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="date", value="Sun, 11 Aug 2019 15:02:37 GMT", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="tpp-redirect-uri", value="Uri of TPP", dataType="String", paramType="header"), @ApiImplicitParam(name="digest", value="730f75dafd73e047b86acb2dbd74e75dcb93272fa084a9082848f2341aa1abb6", dataType="String", paramType="header"), @ApiImplicitParam(name="signature", value="98c0", dataType="String", paramType="header"), @ApiImplicitParam(name="tpp-signature-certificate", value="some certificate", dataType="String", paramType="header"), @ApiImplicitParam(name="tpp-qwac-certificate", value="qwac certificate", required=true, dataType="String", paramType="header")})
    public ResponseEntity<List<PaymentInitialisationResponse>> createBulkPaymentInitiation(@ApiParam(name="payment-product", value="The addressed payment product endpoint for bulk payments e.g. for a bulk SEPA Credit Transfers", allowableValues="sepa-credit-transfers, target-2-payments,instant-sepa-credit-transfers, cross-border-credit-transfers") @PathVariable(value="payment-product") String paymentProduct, @RequestHeader(name="tpp-signature-certificate", required=false) String tppSignatureCertificate, @ApiParam(name="Bulk Payment", value="All data relevant for the corresponding payment product and necessary for execution of the standing order.", required=true) @RequestBody List<SinglePayment> payments) {
        for (SinglePayment payment : payments) {
            ResponseObject accountReferenceValidationResponse = this.referenceValidationService.validateAccountReferences(payment.getAccountReferences());
            if (!accountReferenceValidationResponse.hasError()) continue;
            return this.responseMapper.created(ResponseObject.builder().fail(accountReferenceValidationResponse.getError()).build());
        }
        return this.responseMapper.created(this.paymentService.createBulkPayments(payments, tppSignatureCertificate, paymentProduct));
    }

    @ConstructorProperties(value={"responseMapper", "paymentService", "referenceValidationService"})
    public BulkPaymentInitiationController(ResponseMapper responseMapper, PaymentService paymentService, AccountReferenceValidationService referenceValidationService) {
        this.responseMapper = responseMapper;
        this.paymentService = paymentService;
        this.referenceValidationService = referenceValidationService;
    }
}

