/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.validator;

import de.adorsys.aspsp.xs2a.consent.api.pis.PisPaymentType;
import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentProduct;
import de.adorsys.aspsp.xs2a.service.profile.AspspProfileService;
import de.adorsys.aspsp.xs2a.service.validator.header.HeadersFactory;
import de.adorsys.aspsp.xs2a.service.validator.header.RequestHeader;
import de.adorsys.aspsp.xs2a.service.validator.header.impl.ErrorMessageHeaderImpl;
import de.adorsys.aspsp.xs2a.service.validator.parameter.ParametersFactory;
import de.adorsys.aspsp.xs2a.service.validator.parameter.RequestParameter;
import de.adorsys.aspsp.xs2a.service.validator.parameter.impl.ErrorMessageParameterImpl;
import de.adorsys.aspsp.xs2a.web.BulkPaymentInitiationController;
import de.adorsys.aspsp.xs2a.web.PaymentInitiationController;
import de.adorsys.aspsp.xs2a.web.PeriodicPaymentsController;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;

@Service
public class RequestValidatorService {
    private static final Logger log = Logger.getLogger(RequestValidatorService.class);
    @Autowired
    private ParametersFactory parametersFactory;
    @Autowired
    private Validator validator;
    @Autowired
    private AspspProfileService aspspProfileService;
    private static final String PAYMENT_PRODUCT_PATH_VAR = "payment-product";
    private static final Map<Object, PisPaymentType> classMap = new HashMap<Object, PisPaymentType>();

    public Map<String, String> getRequestViolationMap(HttpServletRequest request, Object handler) {
        HashMap<String, String> violationMap = new HashMap<String, String>();
        if (handler instanceof CorsConfigurationSource) {
            return violationMap;
        }
        violationMap.putAll(this.getRequestHeaderViolationMap(request, handler));
        violationMap.putAll(this.getRequestParametersViolationMap(request, handler));
        violationMap.putAll(this.getRequestPathVariablesViolationMap(request, handler));
        return violationMap;
    }

    private Map<String, String> getRequestParametersViolationMap(HttpServletRequest request, Object handler) {
        Map<String, String> requestParameterMap = this.getRequestParametersMap(request);
        RequestParameter parameterImpl = this.parametersFactory.getParameterImpl(requestParameterMap, ((HandlerMethod)handler).getBeanType());
        if (parameterImpl instanceof ErrorMessageParameterImpl) {
            return Collections.singletonMap("Wrong parameters : ", ((ErrorMessageParameterImpl)parameterImpl).getErrorMessage());
        }
        return this.getViolationMessagesMap(this.validator.validate((Object)parameterImpl, new Class[0]));
    }

    Map<String, String> getRequestPathVariablesViolationMap(HttpServletRequest request, Object handler) {
        HashMap<String, String> requestPathViolationMap = new HashMap<String, String>();
        requestPathViolationMap.putAll(this.checkPaymentProductByRequest(request));
        requestPathViolationMap.putAll(this.getPaymentTypeViolationMap(handler));
        return requestPathViolationMap;
    }

    Map<String, String> getPaymentTypeViolationMap(Object handler) {
        return Optional.ofNullable(classMap.get(((HandlerMethod)handler).getBeanType())).map(this::getViolationMapForPaymentType).orElseGet(Collections::emptyMap);
    }

    Map<String, String> getRequestHeaderViolationMap(HttpServletRequest request, Object handler) {
        Map<String, String> requestHeadersMap = this.getRequestHeadersMap(request);
        RequestHeader headerImpl = HeadersFactory.getHeadersImpl(requestHeadersMap, ((HandlerMethod)handler).getBeanType());
        if (headerImpl instanceof ErrorMessageHeaderImpl) {
            return Collections.singletonMap("Wrong header arguments: ", ((ErrorMessageHeaderImpl)headerImpl).getErrorMessage());
        }
        return this.getViolationMessagesMap(this.validator.validate((Object)headerImpl, new Class[0]));
    }

    private Map<String, String> getRequestHeadersMap(HttpServletRequest request) {
        HashMap<String, String> requestHeaderMap = new HashMap<String, String>();
        if (request == null) {
            return requestHeaderMap;
        }
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            requestHeaderMap.put(key, value);
        }
        requestHeaderMap.putIfAbsent("date", "Sun, 11 Aug 2019 15:02:37 GMT");
        return requestHeaderMap;
    }

    private Map<String, String> getRequestParametersMap(HttpServletRequest request) {
        return request.getParameterMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.join((CharSequence)",", (CharSequence[])e.getValue())));
    }

    private Map<String, String> checkPaymentProductByRequest(HttpServletRequest request) {
        Map pathVariableMap = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        return Optional.ofNullable(pathVariableMap).map(mp -> (String)mp.get(PAYMENT_PRODUCT_PATH_VAR)).map(this::checkPaymentProductSupportAndGetViolationMap).orElseGet(Collections::emptyMap);
    }

    private Map<String, String> checkPaymentProductSupportAndGetViolationMap(String paymentProduct) {
        return Optional.ofNullable(paymentProduct).flatMap(PaymentProduct::getByCode).map(this::getViolationMapForPaymentProduct).orElseGet(() -> Collections.singletonMap(MessageErrorCode.PRODUCT_UNKNOWN.getName(), "Wrong payment product: " + paymentProduct));
    }

    private Map<String, String> getViolationMapForPaymentProduct(PaymentProduct paymentProduct) {
        return this.isPaymentProductAvailable(paymentProduct) ? Collections.emptyMap() : Collections.singletonMap(MessageErrorCode.PRODUCT_UNKNOWN.getName(), "Wrong payment product: " + paymentProduct.getCode());
    }

    private Map<String, String> getViolationMapForPaymentType(PisPaymentType paymentType) {
        return this.isPaymentTypeAvailable(paymentType) ? Collections.emptyMap() : Collections.singletonMap(MessageErrorCode.PARAMETER_NOT_SUPPORTED.getName(), "Wrong payment type: " + paymentType.getValue());
    }

    private boolean isPaymentProductAvailable(PaymentProduct paymentProduct) {
        List<PaymentProduct> paymentProducts = this.aspspProfileService.getAvailablePaymentProducts();
        return paymentProducts.contains((Object)paymentProduct);
    }

    private boolean isPaymentTypeAvailable(PisPaymentType paymentType) {
        List<PisPaymentType> paymentTypes = this.aspspProfileService.getAvailablePaymentTypes();
        return paymentTypes.contains(paymentType);
    }

    private <T> Map<String, String> getViolationMessagesMap(Set<ConstraintViolation<T>> collection) {
        return collection.stream().collect(Collectors.toMap(violation -> violation.getPropertyPath().toString(), violation -> "'" + violation.getPropertyPath().toString() + "' " + violation.getMessage()));
    }

    static {
        classMap.put(PaymentInitiationController.class, PisPaymentType.FUTURE_DATED);
        classMap.put(BulkPaymentInitiationController.class, PisPaymentType.BULK);
        classMap.put(PeriodicPaymentsController.class, PisPaymentType.PERIODIC);
    }
}

