/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.profile;

import de.adorsys.aspsp.xs2a.config.rest.profile.AspspProfileRemoteUrls;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisPaymentType;
import de.adorsys.aspsp.xs2a.domain.account.SupportedAccountReferenceField;
import de.adorsys.aspsp.xs2a.domain.aspsp.AspspSettings;
import de.adorsys.aspsp.xs2a.domain.aspsp.ScaApproach;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentProduct;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AspspProfileService {
    @Qualifier(value="aspspProfileRestTemplate")
    private final RestTemplate aspspProfileRestTemplate;
    private final AspspProfileRemoteUrls aspspProfileRemoteUrls;

    public List<PaymentProduct> getAvailablePaymentProducts() {
        return Optional.ofNullable(this.readAspspSettings().getAvailablePaymentProducts()).map(list -> list.stream().map(PaymentProduct::getByCode).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }

    public List<PisPaymentType> getAvailablePaymentTypes() {
        List<String> availablePaymentTypes = this.readAvailablePaymentTypes();
        return CollectionUtils.isEmpty(availablePaymentTypes) ? Collections.emptyList() : this.getPisPaymentTypes(availablePaymentTypes);
    }

    private List<String> readAvailablePaymentTypes() {
        return this.readAspspSettings().getAvailablePaymentTypes();
    }

    private List<PisPaymentType> getPisPaymentTypes(List<String> availablePaymentTypes) {
        return availablePaymentTypes.stream().map(PisPaymentType::getByValue).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public boolean isRedirectMode() {
        ScaApproach scaApproach = this.readScaApproach();
        return scaApproach == ScaApproach.REDIRECT || scaApproach == ScaApproach.DECOUPLED;
    }

    public ScaApproach readScaApproach() {
        return (ScaApproach)((Object)this.aspspProfileRestTemplate.exchange(this.aspspProfileRemoteUrls.getScaApproach(), HttpMethod.GET, null, ScaApproach.class, new Object[0]).getBody());
    }

    public Boolean getTppSignatureRequired() {
        return this.readAspspSettings().isTppSignatureRequired();
    }

    public String getPisRedirectUrlToAspsp() {
        return this.readAspspSettings().getPisRedirectUrlToAspsp();
    }

    public String getAisRedirectUrlToAspsp() {
        return this.readAspspSettings().getAisRedirectUrlToAspsp();
    }

    public List<SupportedAccountReferenceField> getSupportedAccountReferenceFields() {
        return this.readAspspSettings().getSupportedAccountReferenceFields();
    }

    public int getConsentLifetime() {
        return this.readAspspSettings().getConsentLifetime();
    }

    public Boolean getAllPsd2Support() {
        return this.readAspspSettings().isAllPsd2Support();
    }

    public boolean isBankOfferedConsentSupported() {
        return this.readAspspSettings().isBankOfferedConsentSupport();
    }

    private AspspSettings readAspspSettings() {
        return (AspspSettings)this.aspspProfileRestTemplate.exchange(this.aspspProfileRemoteUrls.getAspspSettings(), HttpMethod.GET, null, AspspSettings.class, new Object[0]).getBody();
    }

    @ConstructorProperties(value={"aspspProfileRestTemplate", "aspspProfileRemoteUrls"})
    public AspspProfileService(RestTemplate aspspProfileRestTemplate, AspspProfileRemoteUrls aspspProfileRemoteUrls) {
        this.aspspProfileRestTemplate = aspspProfileRestTemplate;
        this.aspspProfileRemoteUrls = aspspProfileRemoteUrls;
    }
}

