/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.payment;

import com.google.common.collect.Lists;
import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.domain.TransactionStatus;
import de.adorsys.aspsp.xs2a.domain.consent.CreatePisConsentData;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.aspsp.xs2a.domain.pis.SinglePayment;
import de.adorsys.aspsp.xs2a.domain.pis.TppInfo;
import de.adorsys.aspsp.xs2a.service.mapper.PaymentMapper;
import de.adorsys.aspsp.xs2a.service.mapper.consent.PisConsentMapper;
import de.adorsys.aspsp.xs2a.service.payment.ScaPaymentService;
import de.adorsys.aspsp.xs2a.spi.domain.consent.AspspConsentData;
import de.adorsys.aspsp.xs2a.spi.domain.consent.SpiPisConsentRequest;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiPaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.aspsp.xs2a.spi.service.ConsentSpi;
import de.adorsys.aspsp.xs2a.spi.service.PaymentSpi;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class RedirectScaPaymentService
implements ScaPaymentService {
    private final ConsentSpi consentSpi;
    private final PaymentMapper paymentMapper;
    private final PaymentSpi paymentSpi;
    private final PisConsentMapper pisConsentMapper;

    @Override
    public PaymentInitialisationResponse createPeriodicPayment(PeriodicPayment periodicPayment, TppInfo tppInfo, String paymentProduct) {
        AspspConsentData aspspConsentData = new AspspConsentData();
        PaymentInitialisationResponse response = this.createPeriodicPaymentAndGetResponse(periodicPayment, aspspConsentData);
        return response.getTransactionStatus() != TransactionStatus.RJCT ? this.createConsentForPeriodicPaymentAndExtendPaymentResponse(new CreatePisConsentData(periodicPayment, tppInfo, paymentProduct, aspspConsentData), response) : response;
    }

    private PaymentInitialisationResponse createPeriodicPaymentAndGetResponse(PeriodicPayment periodicPayment, AspspConsentData aspspConsentData) {
        SpiPeriodicPayment spiPeriodicPayment = this.paymentMapper.mapToSpiPeriodicPayment(periodicPayment);
        return this.paymentMapper.mapToPaymentInitializationResponse((SpiPaymentInitialisationResponse)this.paymentSpi.initiatePeriodicPayment(spiPeriodicPayment, aspspConsentData).getPayload());
    }

    private PaymentInitialisationResponse createConsentForPeriodicPaymentAndExtendPaymentResponse(CreatePisConsentData createPisConsentData, PaymentInitialisationResponse response) {
        SpiPisConsentRequest request = this.pisConsentMapper.mapToSpiPisConsentRequestForPeriodicPayment(createPisConsentData, response.getPaymentId());
        String pisConsentId = this.consentSpi.createPisConsentForPeriodicPaymentAndGetId(request);
        return StringUtils.isBlank((CharSequence)pisConsentId) ? null : this.extendPaymentResponseFields(response, pisConsentId);
    }

    @Override
    public List<PaymentInitialisationResponse> createBulkPayment(List<SinglePayment> payments, TppInfo tppInfo, String paymentProduct) {
        AspspConsentData aspspConsentData = new AspspConsentData();
        Map<SinglePayment, PaymentInitialisationResponse> paymentIdentifierMap = this.createBulkPaymentAndGetResponseMap(payments, aspspConsentData);
        return MapUtils.isNotEmpty(paymentIdentifierMap) ? this.createConsentForBulkPaymentAndExtendPaymentResponses(new CreatePisConsentData(paymentIdentifierMap, tppInfo, paymentProduct, aspspConsentData)) : Collections.emptyList();
    }

    private Map<SinglePayment, PaymentInitialisationResponse> createBulkPaymentAndGetResponseMap(List<SinglePayment> payments, AspspConsentData aspspConsentData) {
        HashMap<SinglePayment, PaymentInitialisationResponse> paymentIdentifierMap = new HashMap<SinglePayment, PaymentInitialisationResponse>();
        for (SinglePayment payment : payments) {
            PaymentInitialisationResponse paymentInitialisationResponse = this.createSinglePaymentAndGetResponse(payment, aspspConsentData);
            paymentIdentifierMap.put(payment, paymentInitialisationResponse);
        }
        paymentIdentifierMap.forEach((sp, resp) -> {
            if (StringUtils.isBlank((CharSequence)resp.getPaymentId()) || resp.getTransactionStatus() == TransactionStatus.RJCT) {
                resp.setTppMessages(new MessageErrorCode[]{MessageErrorCode.PAYMENT_FAILED});
                resp.setTransactionStatus(TransactionStatus.RJCT);
            }
        });
        return paymentIdentifierMap;
    }

    private List<PaymentInitialisationResponse> createBulkPaymentAndGetResponse(List<SinglePayment> payments) {
        List<SpiSinglePayment> spiPayments = this.paymentMapper.mapToSpiSinglePaymentList(payments);
        List spiPaymentInitiations = (List)this.paymentSpi.createBulkPayments(spiPayments, new AspspConsentData()).getPayload();
        List<PaymentInitialisationResponse> paymentResponses = spiPaymentInitiations.stream().map(this.paymentMapper::mapToPaymentInitializationResponse).collect(Collectors.toList());
        for (PaymentInitialisationResponse resp : paymentResponses) {
            if (!StringUtils.isBlank((CharSequence)resp.getPaymentId()) && resp.getTransactionStatus() != TransactionStatus.RJCT) continue;
            resp.setTppMessages(new MessageErrorCode[]{MessageErrorCode.PAYMENT_FAILED});
            resp.setTransactionStatus(TransactionStatus.RJCT);
        }
        return paymentResponses;
    }

    private List<PaymentInitialisationResponse> createConsentForBulkPaymentAndExtendPaymentResponses(CreatePisConsentData createPisConsentData) {
        SpiPisConsentRequest request = this.pisConsentMapper.mapToSpiPisConsentRequestForBulkPayment(createPisConsentData);
        String pisConsentId = this.consentSpi.createPisConsentForBulkPaymentAndGetId(request);
        ArrayList responses = Lists.newArrayList(createPisConsentData.getPaymentIdentifierMap().values());
        return responses.stream().map(resp -> this.extendPaymentResponseFields((PaymentInitialisationResponse)resp, pisConsentId)).collect(Collectors.toList());
    }

    @Override
    public PaymentInitialisationResponse createSinglePayment(SinglePayment singlePayment, TppInfo tppInfo, String paymentProduct) {
        AspspConsentData aspspConsentData = new AspspConsentData();
        PaymentInitialisationResponse response = this.createSinglePaymentAndGetResponse(singlePayment, aspspConsentData);
        return response.getTransactionStatus() != TransactionStatus.RJCT ? this.createConsentForSinglePaymentAndExtendPaymentResponse(new CreatePisConsentData(singlePayment, tppInfo, paymentProduct, aspspConsentData), response) : response;
    }

    private PaymentInitialisationResponse createSinglePaymentAndGetResponse(SinglePayment singlePayment, AspspConsentData aspspConsentData) {
        SpiSinglePayment spiSinglePayment = this.paymentMapper.mapToSpiSinglePayment(singlePayment);
        SpiPaymentInitialisationResponse spiSinglePaymentResp = (SpiPaymentInitialisationResponse)this.paymentSpi.createPaymentInitiation(spiSinglePayment, aspspConsentData).getPayload();
        return this.paymentMapper.mapToPaymentInitializationResponse(spiSinglePaymentResp);
    }

    private PaymentInitialisationResponse createConsentForSinglePaymentAndExtendPaymentResponse(CreatePisConsentData createPisConsentData, PaymentInitialisationResponse response) {
        SpiPisConsentRequest request = this.pisConsentMapper.mapToSpiPisConsentRequestForSinglePayment(createPisConsentData, response.getPaymentId());
        String pisConsentId = this.consentSpi.createPisConsentForSinglePaymentAndGetId(request);
        return StringUtils.isBlank((CharSequence)pisConsentId) ? null : this.extendPaymentResponseFields(response, pisConsentId);
    }

    private PaymentInitialisationResponse extendPaymentResponseFields(PaymentInitialisationResponse response, String pisConsentId) {
        response.setPisConsentId(pisConsentId);
        return response;
    }

    @ConstructorProperties(value={"consentSpi", "paymentMapper", "paymentSpi", "pisConsentMapper"})
    public RedirectScaPaymentService(ConsentSpi consentSpi, PaymentMapper paymentMapper, PaymentSpi paymentSpi, PisConsentMapper pisConsentMapper) {
        this.consentSpi = consentSpi;
        this.paymentMapper = paymentMapper;
        this.paymentSpi = paymentSpi;
        this.pisConsentMapper = pisConsentMapper;
    }
}

