/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.payment;

import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.domain.TransactionStatus;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.aspsp.xs2a.domain.pis.SinglePayment;
import de.adorsys.aspsp.xs2a.domain.pis.TppInfo;
import de.adorsys.aspsp.xs2a.service.mapper.PaymentMapper;
import de.adorsys.aspsp.xs2a.service.payment.ScaPaymentService;
import de.adorsys.aspsp.xs2a.spi.domain.consent.AspspConsentData;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiPaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.aspsp.xs2a.spi.service.PaymentSpi;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class OauthScaPaymentService
implements ScaPaymentService {
    private final PaymentMapper paymentMapper;
    private final PaymentSpi paymentSpi;

    @Override
    public PaymentInitialisationResponse createPeriodicPayment(PeriodicPayment periodicPayment, TppInfo tppInfo, String paymentProduct) {
        SpiPeriodicPayment spiPeriodicPayment = this.paymentMapper.mapToSpiPeriodicPayment(periodicPayment);
        return this.paymentMapper.mapToPaymentInitializationResponse((SpiPaymentInitialisationResponse)this.paymentSpi.initiatePeriodicPayment(spiPeriodicPayment, new AspspConsentData()).getPayload());
    }

    @Override
    public List<PaymentInitialisationResponse> createBulkPayment(List<SinglePayment> payments, TppInfo tppInfo, String paymentProduct) {
        List<SpiSinglePayment> spiPayments = this.paymentMapper.mapToSpiSinglePaymentList(payments);
        List spiPaymentInitiations = (List)this.paymentSpi.createBulkPayments(spiPayments, new AspspConsentData()).getPayload();
        return spiPaymentInitiations.stream().map(this.paymentMapper::mapToPaymentInitializationResponse).peek(resp -> {
            if (StringUtils.isBlank((CharSequence)resp.getPaymentId()) || resp.getTransactionStatus() == TransactionStatus.RJCT) {
                resp.setTppMessages(new MessageErrorCode[]{MessageErrorCode.PAYMENT_FAILED});
                resp.setTransactionStatus(TransactionStatus.RJCT);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public PaymentInitialisationResponse createSinglePayment(SinglePayment singlePayment, TppInfo tppInfo, String paymentProduct) {
        SpiSinglePayment spiSinglePayment = this.paymentMapper.mapToSpiSinglePayment(singlePayment);
        SpiPaymentInitialisationResponse spiPeriodicPaymentResp = (SpiPaymentInitialisationResponse)this.paymentSpi.createPaymentInitiation(spiSinglePayment, new AspspConsentData()).getPayload();
        return this.paymentMapper.mapToPaymentInitializationResponse(spiPeriodicPaymentResp);
    }

    @ConstructorProperties(value={"paymentMapper", "paymentSpi"})
    public OauthScaPaymentService(PaymentMapper paymentMapper, PaymentSpi paymentSpi) {
        this.paymentMapper = paymentMapper;
        this.paymentSpi = paymentSpi;
    }
}

