/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.mapper.consent;

import de.adorsys.aspsp.xs2a.domain.consent.CreatePisConsentData;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.domain.pis.SinglePayment;
import de.adorsys.aspsp.xs2a.domain.pis.TppInfo;
import de.adorsys.aspsp.xs2a.service.mapper.PaymentMapper;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiTppInfo;
import de.adorsys.aspsp.xs2a.spi.domain.consent.SpiPisConsentRequest;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiPaymentType;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiSinglePayment;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class PisConsentMapper {
    private final PaymentMapper paymentMapper;

    public SpiPisConsentRequest mapToSpiPisConsentRequestForSinglePayment(CreatePisConsentData createPisConsentData, String paymentId) {
        SpiPisConsentRequest request = new SpiPisConsentRequest();
        request.setPayments(Arrays.asList(this.mapToSpiSinglePaymentWithPaymentId(createPisConsentData, paymentId)));
        request.setPaymentProduct(createPisConsentData.getPaymentProduct());
        request.setPaymentType(SpiPaymentType.SINGLE);
        request.setTppInfo(this.mapToSpiTppInfo(createPisConsentData.getTppInfo()));
        request.setAspspConsentData(createPisConsentData.getAspspConsentData());
        return request;
    }

    public SpiPisConsentRequest mapToSpiPisConsentRequestForPeriodicPayment(CreatePisConsentData createPisConsentData, String paymentId) {
        SpiPisConsentRequest request = new SpiPisConsentRequest();
        request.setPayments(Arrays.asList(this.mapToSpiPeriodicPaymentWithPaymentId(createPisConsentData, paymentId)));
        request.setPaymentProduct(createPisConsentData.getPaymentProduct());
        request.setPaymentType(SpiPaymentType.PERIODIC);
        request.setTppInfo(this.mapToSpiTppInfo(createPisConsentData.getTppInfo()));
        request.setAspspConsentData(createPisConsentData.getAspspConsentData());
        return request;
    }

    public SpiPisConsentRequest mapToSpiPisConsentRequestForBulkPayment(CreatePisConsentData createPisConsentData) {
        SpiPisConsentRequest request = new SpiPisConsentRequest();
        request.setPayments(this.mapToSpiSinglePaymentList(createPisConsentData.getPaymentIdentifierMap()));
        request.setPaymentProduct(createPisConsentData.getPaymentProduct());
        request.setPaymentType(SpiPaymentType.BULK);
        request.setTppInfo(this.mapToSpiTppInfo(createPisConsentData.getTppInfo()));
        request.setAspspConsentData(createPisConsentData.getAspspConsentData());
        return request;
    }

    private SpiSinglePayment mapToSpiSinglePaymentWithPaymentId(CreatePisConsentData createPisConsentData, String paymentId) {
        SpiSinglePayment spiSinglePayment = this.paymentMapper.mapToSpiSinglePayment(createPisConsentData.getSinglePayment());
        spiSinglePayment.setPaymentId(paymentId);
        return spiSinglePayment;
    }

    private SpiPeriodicPayment mapToSpiPeriodicPaymentWithPaymentId(CreatePisConsentData createPisConsentData, String paymentId) {
        SpiPeriodicPayment spiPeriodicPayment = this.paymentMapper.mapToSpiPeriodicPayment(createPisConsentData.getPeriodicPayment());
        spiPeriodicPayment.setPaymentId(paymentId);
        return spiPeriodicPayment;
    }

    private List<SpiSinglePayment> mapToSpiSinglePaymentList(Map<SinglePayment, PaymentInitialisationResponse> paymentIdentifierMap) {
        return paymentIdentifierMap.entrySet().stream().map(etr -> {
            SpiSinglePayment spiSinglePayment = this.paymentMapper.mapToSpiSinglePayment((SinglePayment)etr.getKey());
            spiSinglePayment.setPaymentId(((PaymentInitialisationResponse)etr.getValue()).getPaymentId());
            return spiSinglePayment;
        }).collect(Collectors.toList());
    }

    private SpiTppInfo mapToSpiTppInfo(TppInfo tppInfo) {
        return Optional.ofNullable(tppInfo).map(info -> new SpiTppInfo(info.getRegistrationNumber(), info.getTppName(), info.getTppRole(), info.getNationalCompetentAuthority(), info.getRedirectUri(), info.getNokRedirectUri())).orElse(null);
    }

    @ConstructorProperties(value={"paymentMapper"})
    public PisConsentMapper(PaymentMapper paymentMapper) {
        this.paymentMapper = paymentMapper;
    }
}

