/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.mapper.consent;

import de.adorsys.aspsp.xs2a.consent.api.ActionStatus;
import de.adorsys.aspsp.xs2a.consent.api.TypeAccess;
import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.domain.consent.AccountAccess;
import de.adorsys.aspsp.xs2a.domain.consent.AccountAccessType;
import de.adorsys.aspsp.xs2a.domain.consent.AccountConsent;
import de.adorsys.aspsp.xs2a.domain.consent.ConsentStatus;
import de.adorsys.aspsp.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.aspsp.xs2a.service.mapper.AccountMapper;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.aspsp.xs2a.spi.domain.consent.AspspConsentData;
import de.adorsys.aspsp.xs2a.spi.domain.consent.SpiAccountAccess;
import de.adorsys.aspsp.xs2a.spi.domain.consent.SpiAccountAccessType;
import de.adorsys.aspsp.xs2a.spi.domain.consent.SpiConsentStatus;
import de.adorsys.aspsp.xs2a.spi.domain.consent.SpiCreateAisConsentRequest;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class AisConsentMapper {
    private final AccountMapper accountMapper;

    public SpiCreateAisConsentRequest mapToSpiCreateAisConsentRequest(CreateConsentReq req, String psuId, String tppId, AspspConsentData aspspConsentData) {
        return Optional.ofNullable(req).map(r -> {
            SpiCreateAisConsentRequest aisRequest = new SpiCreateAisConsentRequest();
            aisRequest.setPsuId(psuId);
            aisRequest.setTppId(tppId);
            aisRequest.setFrequencyPerDay(r.getFrequencyPerDay());
            aisRequest.setAccess(this.mapToSpiAccountAccess(req.getAccess()));
            aisRequest.setValidUntil(r.getValidUntil());
            aisRequest.setRecurringIndicator(r.isRecurringIndicator());
            aisRequest.setCombinedServiceIndicator(r.isCombinedServiceIndicator());
            aisRequest.setAspspConsentData(aspspConsentData.getAspspConsentData());
            return aisRequest;
        }).orElse(null);
    }

    public AccountConsent mapToAccountConsent(SpiAccountConsent spiAccountConsent) {
        return Optional.ofNullable(spiAccountConsent).map(ac -> new AccountConsent(ac.getId(), this.mapToAccountAccess(ac.getAccess()), ac.isRecurringIndicator(), ac.getValidUntil(), ac.getFrequencyPerDay(), ac.getLastActionDate(), ConsentStatus.valueOf(ac.getConsentStatus().name()), ac.isWithBalance(), ac.isTppRedirectPreferred())).orElse(null);
    }

    public Optional<ConsentStatus> mapToConsentStatus(SpiConsentStatus spiConsentStatus) {
        return Optional.ofNullable(spiConsentStatus).map(status -> ConsentStatus.valueOf(status.name()));
    }

    public ActionStatus mapActionStatusError(MessageErrorCode error, boolean withBalance, TypeAccess access) {
        ActionStatus actionStatus = ActionStatus.FAILURE_ACCOUNT;
        if (error == MessageErrorCode.ACCESS_EXCEEDED) {
            actionStatus = ActionStatus.CONSENT_LIMIT_EXCEEDED;
        } else if (error == MessageErrorCode.CONSENT_EXPIRED) {
            actionStatus = ActionStatus.CONSENT_INVALID_STATUS;
        } else if (error == MessageErrorCode.CONSENT_UNKNOWN_400) {
            actionStatus = ActionStatus.CONSENT_NOT_FOUND;
        } else if (error == MessageErrorCode.CONSENT_INVALID) {
            if (access == TypeAccess.TRANSACTION) {
                actionStatus = ActionStatus.FAILURE_TRANSACTION;
            } else if (access == TypeAccess.BALANCE || withBalance) {
                actionStatus = ActionStatus.FAILURE_BALANCE;
            }
        }
        return actionStatus;
    }

    private AccountAccess mapToAccountAccess(SpiAccountAccess access) {
        return Optional.ofNullable(access).map(aa -> new AccountAccess(this.accountMapper.mapToAccountReferences(aa.getAccounts()), this.accountMapper.mapToAccountReferences(aa.getBalances()), this.accountMapper.mapToAccountReferences(aa.getTransactions()), this.mapToAccountAccessType(aa.getAvailableAccounts()), this.mapToAccountAccessType(aa.getAllPsd2()))).orElse(null);
    }

    private AccountAccessType mapToAccountAccessType(SpiAccountAccessType accessType) {
        return Optional.ofNullable(accessType).map(at -> AccountAccessType.valueOf(at.name())).orElse(null);
    }

    private SpiAccountAccess mapToSpiAccountAccess(AccountAccess access) {
        return Optional.ofNullable(access).map(aa -> {
            SpiAccountAccess spiAccountAccess = new SpiAccountAccess();
            spiAccountAccess.setAccounts(this.accountMapper.mapToSpiAccountReferences(aa.getAccounts()));
            spiAccountAccess.setBalances(this.accountMapper.mapToSpiAccountReferences(aa.getBalances()));
            spiAccountAccess.setTransactions(this.accountMapper.mapToSpiAccountReferences(aa.getTransactions()));
            spiAccountAccess.setAvailableAccounts(this.mapToSpiAccountAccessType(aa.getAvailableAccounts()));
            spiAccountAccess.setAllPsd2(this.mapToSpiAccountAccessType(aa.getAllPsd2()));
            return spiAccountAccess;
        }).orElse(null);
    }

    private SpiAccountAccessType mapToSpiAccountAccessType(AccountAccessType accessType) {
        return Optional.ofNullable(accessType).map(at -> SpiAccountAccessType.valueOf((String)at.name())).orElse(null);
    }

    @ConstructorProperties(value={"accountMapper"})
    public AisConsentMapper(AccountMapper accountMapper) {
        this.accountMapper = accountMapper;
    }
}

