/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.mapper;

import de.adorsys.aspsp.xs2a.domain.ResponseObject;
import de.adorsys.aspsp.xs2a.exception.MessageError;
import java.util.function.Function;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class ResponseMapper {
    public <T, R> ResponseEntity<?> ok(ResponseObject<T> response, Function<T, R> mapper) {
        return this.getEntity(response, HttpStatus.OK, mapper);
    }

    public <T, R> ResponseEntity<?> created(ResponseObject<T> response, Function<T, R> mapper) {
        return this.getEntity(response, HttpStatus.CREATED, mapper);
    }

    public <T, R> ResponseEntity<?> delete(ResponseObject<T> response, Function<T, R> mapper) {
        return this.getEntity(response, HttpStatus.NO_CONTENT, mapper);
    }

    public <T> ResponseEntity<T> ok(ResponseObject<T> response) {
        return this.getEntity(response, HttpStatus.OK);
    }

    public <T> ResponseEntity<T> created(ResponseObject<T> response) {
        return this.getEntity(response, HttpStatus.CREATED);
    }

    public <T> ResponseEntity<T> delete(ResponseObject<T> response) {
        return this.getEntity(response, HttpStatus.NO_CONTENT);
    }

    private <T> ResponseEntity<T> getEntity(ResponseObject<T> response, HttpStatus status) {
        return this.getEntity(response, status, null);
    }

    private <T, R> ResponseEntity getEntity(ResponseObject<T> response, HttpStatus status, Function<T, R> mapper) {
        T body = response.getBody();
        return response.hasError() ? this.createErrorResponse(response.getError()) : new ResponseEntity(this.getBody(body, mapper), status);
    }

    private <T, R> Object getBody(T body, Function<T, R> mapper) {
        return mapper == null ? body : mapper.apply(body);
    }

    private ResponseEntity createErrorResponse(MessageError error) {
        return new ResponseEntity((Object)error, HttpStatus.valueOf((int)error.getTppMessage().getMessageErrorCode().getCode()));
    }
}

