/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.aspsp.xs2a.domain.TransactionStatus;
import de.adorsys.aspsp.xs2a.domain.account.AccountReference;
import de.adorsys.aspsp.xs2a.domain.code.BICFI;
import de.adorsys.aspsp.xs2a.domain.code.FrequencyCode;
import de.adorsys.aspsp.xs2a.domain.code.PurposeCode;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentProduct;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentType;
import de.adorsys.aspsp.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.aspsp.xs2a.domain.pis.Remittance;
import de.adorsys.aspsp.xs2a.domain.pis.SinglePayment;
import de.adorsys.aspsp.xs2a.service.mapper.AccountModelMapper;
import de.adorsys.aspsp.xs2a.service.validator.ValueValidatorService;
import de.adorsys.psd2.model.BulkPaymentInitiationSctJson;
import de.adorsys.psd2.model.BulkPaymentInitiationTarget2WithStatusResponse;
import de.adorsys.psd2.model.DayOfExecution;
import de.adorsys.psd2.model.ExecutionRule;
import de.adorsys.psd2.model.PaymentInitationRequestResponse201;
import de.adorsys.psd2.model.PaymentInitiationSctJson;
import de.adorsys.psd2.model.PaymentInitiationTarget2Json;
import de.adorsys.psd2.model.PaymentInitiationTarget2WithStatusResponse;
import de.adorsys.psd2.model.PeriodicPaymentInitiationSctJson;
import de.adorsys.psd2.model.PeriodicPaymentInitiationTarget2WithStatusResponse;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class PaymentModelMapper {
    private final ObjectMapper mapper;
    private final ValueValidatorService validationService;

    public <T> T mapToXs2aPayment(Object payment, PaymentType type, PaymentProduct product) {
        if (type == PaymentType.SINGLE) {
            PaymentInitiationSctJson single = (PaymentInitiationSctJson)this.mapper.convertValue(payment, PaymentInitiationSctJson.class);
            this.validationService.validate(single, new Class[0]);
            return (T)this.mapToXs2aSinglePayment(single);
        }
        if (type == PaymentType.PERIODIC) {
            PeriodicPaymentInitiationSctJson periodic = (PeriodicPaymentInitiationSctJson)this.mapper.convertValue(payment, PeriodicPaymentInitiationSctJson.class);
            this.validationService.validate(periodic, new Class[0]);
            return (T)this.mapToXs2aPeriodicPayment(periodic);
        }
        BulkPaymentInitiationSctJson bulk = (BulkPaymentInitiationSctJson)this.mapper.convertValue(payment, BulkPaymentInitiationSctJson.class);
        this.validationService.validate(bulk, new Class[0]);
        return (T)this.mapToXs2aBulkPayment(bulk);
    }

    private SinglePayment mapToXs2aSinglePayment(PaymentInitiationSctJson paymentRequest) {
        SinglePayment payment = new SinglePayment();
        payment.setEndToEndIdentification(paymentRequest.getEndToEndIdentification());
        payment.setDebtorAccount(this.mapToXs2aAccountReference(paymentRequest.getDebtorAccount()));
        payment.setUltimateDebtor("NOT SUPPORTED");
        payment.setInstructedAmount(AccountModelMapper.mapToXs2aAmount(paymentRequest.getInstructedAmount()));
        payment.setCreditorAccount(this.mapToXs2aAccountReference(paymentRequest.getCreditorAccount()));
        payment.setCreditorAgent(this.mapToXs2aBICFI(paymentRequest.getCreditorAgent()));
        payment.setCreditorName(paymentRequest.getCreditorName());
        payment.setCreditorAddress(AccountModelMapper.mapToXs2aAddress(paymentRequest.getCreditorAddress()));
        payment.setUltimateCreditor(paymentRequest.getCreditorName());
        payment.setPurposeCode(new PurposeCode("N/A"));
        payment.setRemittanceInformationUnstructured(paymentRequest.getRemittanceInformationUnstructured());
        payment.setRemittanceInformationStructured(new Remittance());
        payment.setRequestedExecutionDate(LocalDate.now());
        payment.setRequestedExecutionTime(LocalDateTime.now().plusHours(1L));
        return payment;
    }

    private AccountReference mapToXs2aAccountReference(Object reference12) {
        return (AccountReference)this.mapper.convertValue(reference12, AccountReference.class);
    }

    private PeriodicPayment mapToXs2aPeriodicPayment(PeriodicPaymentInitiationSctJson paymentRequest) {
        PeriodicPayment payment = new PeriodicPayment();
        payment.setEndToEndIdentification(paymentRequest.getEndToEndIdentification());
        payment.setDebtorAccount(this.mapToXs2aAccountReference(paymentRequest.getDebtorAccount()));
        payment.setUltimateDebtor("NOT SUPPORTED");
        payment.setInstructedAmount(AccountModelMapper.mapToXs2aAmount(paymentRequest.getInstructedAmount()));
        payment.setCreditorAccount(this.mapToXs2aAccountReference(paymentRequest.getCreditorAccount()));
        payment.setCreditorAgent(this.mapToXs2aBICFI(paymentRequest.getCreditorAgent()));
        payment.setCreditorName(paymentRequest.getCreditorName());
        payment.setCreditorAddress(AccountModelMapper.mapToXs2aAddress(paymentRequest.getCreditorAddress()));
        payment.setUltimateCreditor(paymentRequest.getCreditorName());
        payment.setPurposeCode(new PurposeCode("N/A"));
        payment.setRemittanceInformationUnstructured(paymentRequest.getRemittanceInformationUnstructured());
        payment.setRemittanceInformationStructured(new Remittance());
        payment.setRequestedExecutionDate(LocalDate.now());
        payment.setRequestedExecutionTime(LocalDateTime.now().plusHours(1L));
        payment.setStartDate(paymentRequest.getStartDate());
        payment.setExecutionRule(Optional.ofNullable(paymentRequest.getExecutionRule()).map(ExecutionRule::toString).orElse(null));
        payment.setEndDate(paymentRequest.getEndDate());
        payment.setFrequency(this.mapToXs2aFrequencyCode(paymentRequest.getFrequency()));
        payment.setDayOfExecution(Integer.parseInt(paymentRequest.getDayOfExecution().toString()));
        return payment;
    }

    private FrequencyCode mapToXs2aFrequencyCode(de.adorsys.psd2.model.FrequencyCode frequency) {
        return FrequencyCode.valueOf(frequency.name());
    }

    private List<SinglePayment> mapToXs2aBulkPayment(BulkPaymentInitiationSctJson paymentRequest) {
        return paymentRequest.getPayments().stream().map(p -> {
            SinglePayment payment = new SinglePayment();
            payment.setDebtorAccount(this.mapToXs2aAccountReference(paymentRequest.getDebtorAccount()));
            payment.setRequestedExecutionDate(paymentRequest.getRequestedExecutionDate());
            payment.setEndToEndIdentification(p.getEndToEndIdentification());
            payment.setUltimateDebtor("NOT SUPPORTED");
            payment.setInstructedAmount(AccountModelMapper.mapToXs2aAmount(p.getInstructedAmount()));
            payment.setCreditorAccount(this.mapToXs2aAccountReference(p.getCreditorAccount()));
            payment.setCreditorAgent(this.mapToXs2aBICFI(p.getCreditorAgent()));
            payment.setCreditorName(p.getCreditorName());
            payment.setCreditorAddress(AccountModelMapper.mapToXs2aAddress(p.getCreditorAddress()));
            payment.setUltimateCreditor(null);
            payment.setPurposeCode(new PurposeCode(null));
            payment.setRemittanceInformationUnstructured(p.getRemittanceInformationUnstructured());
            payment.setRemittanceInformationStructured(new Remittance());
            payment.setRequestedExecutionTime(LocalDateTime.now().plusHours(1L));
            return payment;
        }).collect(Collectors.toList());
    }

    private BICFI mapToXs2aBICFI(String creditorAgent) {
        BICFI bicfi = new BICFI();
        bicfi.setCode(creditorAgent);
        return bicfi;
    }

    public <T, R> T mapToGetPaymentResponse12(R payment, PaymentType type, PaymentProduct product) {
        if (type == PaymentType.SINGLE) {
            SinglePayment xs2aPayment = (SinglePayment)payment;
            PaymentInitiationTarget2WithStatusResponse paymentResponse = new PaymentInitiationTarget2WithStatusResponse();
            paymentResponse.setEndToEndIdentification(xs2aPayment.getEndToEndIdentification());
            paymentResponse.setDebtorAccount(AccountModelMapper.mapToAccountReference12(xs2aPayment.getDebtorAccount()));
            paymentResponse.setInstructedAmount(AccountModelMapper.mapToAmount(xs2aPayment.getInstructedAmount()));
            paymentResponse.setCreditorAccount(AccountModelMapper.mapToAccountReference12(xs2aPayment.getCreditorAccount()));
            paymentResponse.setCreditorAgent(xs2aPayment.getCreditorAgent().getCode());
            paymentResponse.setCreditorName(xs2aPayment.getCreditorName());
            paymentResponse.setCreditorAddress(AccountModelMapper.mapToAddress12(xs2aPayment.getCreditorAddress()));
            paymentResponse.setRemittanceInformationUnstructured(xs2aPayment.getRemittanceInformationUnstructured());
            paymentResponse.setTransactionStatus(PaymentModelMapper.mapToTransactionStatus12(TransactionStatus.RCVD));
            return (T)paymentResponse;
        }
        if (type == PaymentType.PERIODIC) {
            PeriodicPayment xs2aPayment = (PeriodicPayment)payment;
            PeriodicPaymentInitiationTarget2WithStatusResponse paymentResponse = new PeriodicPaymentInitiationTarget2WithStatusResponse();
            paymentResponse.setEndToEndIdentification(xs2aPayment.getEndToEndIdentification());
            paymentResponse.setDebtorAccount(AccountModelMapper.mapToAccountReference12(xs2aPayment.getDebtorAccount()));
            paymentResponse.setInstructedAmount(AccountModelMapper.mapToAmount(xs2aPayment.getInstructedAmount()));
            paymentResponse.setCreditorAccount(AccountModelMapper.mapToAccountReference12(xs2aPayment.getCreditorAccount()));
            paymentResponse.setCreditorAgent(xs2aPayment.getCreditorAgent().getCode());
            paymentResponse.setCreditorName(xs2aPayment.getCreditorName());
            paymentResponse.setCreditorAddress(AccountModelMapper.mapToAddress12(xs2aPayment.getCreditorAddress()));
            paymentResponse.setRemittanceInformationUnstructured(xs2aPayment.getRemittanceInformationUnstructured());
            paymentResponse.setStartDate(xs2aPayment.getStartDate());
            paymentResponse.setEndDate(xs2aPayment.getEndDate());
            paymentResponse.setExecutionRule(ExecutionRule.valueOf((String)xs2aPayment.getExecutionRule()));
            paymentResponse.setFrequency(de.adorsys.psd2.model.FrequencyCode.valueOf((String)xs2aPayment.getFrequency().name()));
            String executionDateString = String.format("%02d", xs2aPayment.getDayOfExecution());
            paymentResponse.setDayOfExecution(DayOfExecution.fromValue((String)executionDateString));
            paymentResponse.setTransactionStatus(PaymentModelMapper.mapToTransactionStatus12(TransactionStatus.RCVD));
            return (T)paymentResponse;
        }
        List xs2aPayment = (List)payment;
        BulkPaymentInitiationTarget2WithStatusResponse paymentResponse = new BulkPaymentInitiationTarget2WithStatusResponse();
        paymentResponse.setBatchBookingPreferred(Boolean.valueOf(false));
        paymentResponse.setRequestedExecutionDate(LocalDate.now());
        paymentResponse.setDebtorAccount(AccountModelMapper.mapToAccountReference12(((SinglePayment)xs2aPayment.get(0)).getDebtorAccount()));
        paymentResponse.setPayments(this.mapToBulkPartList12(xs2aPayment));
        paymentResponse.setTransactionStatus(PaymentModelMapper.mapToTransactionStatus12(TransactionStatus.RCVD));
        return (T)paymentResponse;
    }

    private List<PaymentInitiationTarget2Json> mapToBulkPartList12(List<SinglePayment> payments) {
        return payments.stream().map(PaymentModelMapper::mapToBulkPart12).collect(Collectors.toList());
    }

    private static PaymentInitiationTarget2Json mapToBulkPart12(SinglePayment payment) {
        PaymentInitiationTarget2Json bulkPart = new PaymentInitiationTarget2Json().endToEndIdentification(payment.getEndToEndIdentification());
        bulkPart.setDebtorAccount(AccountModelMapper.mapToAccountReference12(payment.getDebtorAccount()));
        bulkPart.setInstructedAmount(AccountModelMapper.mapToAmount(payment.getInstructedAmount()));
        bulkPart.setCreditorAccount(AccountModelMapper.mapToAccountReference12(payment.getCreditorAccount()));
        bulkPart.setCreditorAgent(payment.getCreditorAgent().getCode());
        bulkPart.setCreditorName(payment.getCreditorName());
        bulkPart.setCreditorAddress(AccountModelMapper.mapToAddress12(payment.getCreditorAddress()));
        bulkPart.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        return bulkPart;
    }

    public static de.adorsys.psd2.model.TransactionStatus mapToTransactionStatus12(TransactionStatus responseObject) {
        return de.adorsys.psd2.model.TransactionStatus.valueOf((String)responseObject.name());
    }

    public <T, R> R mapToPaymentInitiationResponse12(T response, PaymentType type, PaymentProduct product) {
        PaymentInitationRequestResponse201 response201 = new PaymentInitationRequestResponse201();
        if (type == PaymentType.SINGLE || type == PaymentType.PERIODIC) {
            PaymentInitialisationResponse specificResponse = (PaymentInitialisationResponse)response;
            response201.setTransactionStatus(PaymentModelMapper.mapToTransactionStatus12(specificResponse.getTransactionStatus()));
            response201.setPaymentId(specificResponse.getPaymentId());
            response201.setTransactionFees(AccountModelMapper.mapToAmount(specificResponse.getTransactionFees()));
            response201.setTransactionFeeIndicator(Boolean.valueOf(specificResponse.isTransactionFeeIndicator()));
            response201.setScaMethods(null);
            response201.setChosenScaMethod(null);
            response201.setChallengeData(null);
            response201.setLinks(null);
            response201.setPsuMessage(specificResponse.getPsuMessage());
            response201.setTppMessages(null);
            return (R)response201;
        }
        List specificResponse = (List)response;
        return (R)specificResponse.stream().map(r -> this.mapToPaymentInitiationResponse12(r, PaymentType.SINGLE, product)).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"mapper", "validationService"})
    public PaymentModelMapper(ObjectMapper mapper, ValueValidatorService validationService) {
        this.mapper = mapper;
        this.validationService = validationService;
    }
}

