/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.aspsp.xs2a.domain.Amount;
import de.adorsys.aspsp.xs2a.domain.Links;
import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.domain.TransactionStatus;
import de.adorsys.aspsp.xs2a.domain.address.Address;
import de.adorsys.aspsp.xs2a.domain.address.CountryCode;
import de.adorsys.aspsp.xs2a.domain.code.BICFI;
import de.adorsys.aspsp.xs2a.domain.code.FrequencyCode;
import de.adorsys.aspsp.xs2a.domain.code.PurposeCode;
import de.adorsys.aspsp.xs2a.domain.consent.AuthenticationObject;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentType;
import de.adorsys.aspsp.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.aspsp.xs2a.domain.pis.Remittance;
import de.adorsys.aspsp.xs2a.domain.pis.SinglePayment;
import de.adorsys.aspsp.xs2a.domain.pis.TppInfo;
import de.adorsys.aspsp.xs2a.service.mapper.AccountMapper;
import de.adorsys.aspsp.xs2a.spi.domain.common.SpiAmount;
import de.adorsys.aspsp.xs2a.spi.domain.common.SpiTransactionStatus;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiAddress;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiPaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiPaymentType;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiRemittance;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiSinglePayment;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PaymentMapper {
    private static final Logger log = LoggerFactory.getLogger(PaymentMapper.class);
    private final ObjectMapper objectMapper;
    private final AccountMapper accountMapper;

    public TransactionStatus mapToTransactionStatus(SpiTransactionStatus spiTransactionStatus) {
        return Optional.ofNullable(spiTransactionStatus).map(ts -> TransactionStatus.valueOf(ts.name())).orElse(null);
    }

    public List<SpiSinglePayment> mapToSpiSinglePaymentList(List<SinglePayment> payments) {
        return payments.stream().map(this::mapToSpiSinglePayment).collect(Collectors.toList());
    }

    public SpiSinglePayment mapToSpiSinglePayment(SinglePayment paymentInitiationRequest) {
        return Optional.ofNullable(paymentInitiationRequest).map(paymentRe -> {
            SpiSinglePayment spiSinglePayment = new SpiSinglePayment();
            spiSinglePayment.setEndToEndIdentification(paymentRe.getEndToEndIdentification());
            spiSinglePayment.setDebtorAccount(this.accountMapper.mapToSpiAccountReference(paymentRe.getDebtorAccount()));
            spiSinglePayment.setUltimateDebtor(paymentRe.getUltimateDebtor());
            spiSinglePayment.setInstructedAmount(this.mapToSpiAmount(paymentRe.getInstructedAmount()));
            spiSinglePayment.setCreditorAccount(this.accountMapper.mapToSpiAccountReference(paymentRe.getCreditorAccount()));
            spiSinglePayment.setCreditorAgent(Optional.ofNullable(paymentRe.getCreditorAgent()).map(BICFI::getCode).orElse(""));
            spiSinglePayment.setCreditorName(paymentRe.getCreditorName());
            spiSinglePayment.setCreditorAddress(this.mapToSpiAddress(paymentRe.getCreditorAddress()));
            spiSinglePayment.setUltimateCreditor(paymentRe.getUltimateCreditor());
            spiSinglePayment.setPurposeCode(Optional.ofNullable(paymentRe.getPurposeCode()).map(PurposeCode::getCode).orElse(""));
            spiSinglePayment.setRemittanceInformationUnstructured(paymentRe.getRemittanceInformationUnstructured());
            spiSinglePayment.setRemittanceInformationStructured(this.mapToSpiRemittance(paymentRe.getRemittanceInformationStructured()));
            spiSinglePayment.setRequestedExecutionDate(paymentRe.getRequestedExecutionDate());
            spiSinglePayment.setRequestedExecutionTime(paymentRe.getRequestedExecutionTime());
            spiSinglePayment.setPaymentStatus(SpiTransactionStatus.RCVD);
            return spiSinglePayment;
        }).orElse(null);
    }

    public SpiPeriodicPayment mapToSpiPeriodicPayment(PeriodicPayment periodicPayment) {
        return Optional.ofNullable(periodicPayment).map(pp -> {
            SpiPeriodicPayment spiPeriodicPayment = new SpiPeriodicPayment();
            spiPeriodicPayment.setEndToEndIdentification(pp.getEndToEndIdentification());
            spiPeriodicPayment.setDebtorAccount(this.accountMapper.mapToSpiAccountReference(pp.getDebtorAccount()));
            spiPeriodicPayment.setUltimateDebtor(pp.getUltimateDebtor());
            spiPeriodicPayment.setInstructedAmount(this.mapToSpiAmount(pp.getInstructedAmount()));
            spiPeriodicPayment.setCreditorAccount(this.accountMapper.mapToSpiAccountReference(pp.getCreditorAccount()));
            spiPeriodicPayment.setCreditorAgent((String)Optional.ofNullable(pp.getCreditorAgent()).map(BICFI::getCode).orElse(null));
            spiPeriodicPayment.setCreditorName(pp.getCreditorName());
            spiPeriodicPayment.setCreditorAddress(this.mapToSpiAddress(pp.getCreditorAddress()));
            spiPeriodicPayment.setUltimateCreditor(pp.getUltimateCreditor());
            spiPeriodicPayment.setPurposeCode((String)Optional.ofNullable(pp.getPurposeCode()).map(PurposeCode::getCode).orElse(null));
            spiPeriodicPayment.setRemittanceInformationUnstructured(pp.getRemittanceInformationUnstructured());
            spiPeriodicPayment.setRemittanceInformationStructured(this.mapToSpiRemittance(pp.getRemittanceInformationStructured()));
            spiPeriodicPayment.setRequestedExecutionDate(pp.getRequestedExecutionDate());
            spiPeriodicPayment.setRequestedExecutionTime(pp.getRequestedExecutionTime());
            spiPeriodicPayment.setStartDate(pp.getStartDate());
            spiPeriodicPayment.setExecutionRule(pp.getExecutionRule());
            spiPeriodicPayment.setEndDate(pp.getEndDate());
            spiPeriodicPayment.setFrequency((String)Optional.ofNullable(pp.getFrequency()).map(Enum::name).orElse(null));
            spiPeriodicPayment.setDayOfExecution(pp.getDayOfExecution());
            spiPeriodicPayment.setPaymentStatus(SpiTransactionStatus.RCVD);
            return spiPeriodicPayment;
        }).orElse(null);
    }

    public PaymentInitialisationResponse mapToPaymentInitializationResponse(SpiPaymentInitialisationResponse response) {
        return Optional.ofNullable(response).map(pir -> {
            PaymentInitialisationResponse initialisationResponse = new PaymentInitialisationResponse();
            initialisationResponse.setTransactionStatus(this.mapToTransactionStatus(pir.getTransactionStatus()));
            initialisationResponse.setPaymentId(pir.getPaymentId());
            initialisationResponse.setTransactionFees(this.accountMapper.mapToAmount(pir.getSpiTransactionFees()));
            initialisationResponse.setTransactionFeeIndicator(pir.isSpiTransactionFeeIndicator());
            initialisationResponse.setPsuMessage(pir.getPsuMessage());
            initialisationResponse.setTppRedirectPreferred(pir.isTppRedirectPreferred());
            initialisationResponse.setScaMethods(this.mapToAuthenticationObjects(pir.getScaMethods()));
            initialisationResponse.setTppMessages(this.mapToMessageCodes(pir.getTppMessages()));
            initialisationResponse.setLinks(new Links());
            return initialisationResponse;
        }).orElse(new PaymentInitialisationResponse());
    }

    public PaymentInitialisationResponse mapToPaymentInitResponseFailedPayment(SinglePayment payment, MessageErrorCode error) {
        log.warn("Bulk payment initiation has an error: {}. Payment : {}", (Object)error, (Object)payment);
        PaymentInitialisationResponse response = new PaymentInitialisationResponse();
        response.setTransactionStatus(TransactionStatus.RJCT);
        response.setPaymentId(payment.getEndToEndIdentification());
        response.setTppMessages(new MessageErrorCode[]{error});
        return response;
    }

    public SpiPaymentType mapToSpiPaymentType(PaymentType paymentType) {
        return SpiPaymentType.valueOf((String)paymentType.name());
    }

    public SinglePayment mapToSinglePayment(SpiSinglePayment spiSinglePayment) {
        return Optional.ofNullable(spiSinglePayment).map(sp -> {
            SinglePayment payments = new SinglePayment();
            payments.setEndToEndIdentification(spiSinglePayment.getEndToEndIdentification());
            payments.setDebtorAccount(this.accountMapper.mapToAccountReference(spiSinglePayment.getDebtorAccount()));
            payments.setUltimateDebtor(spiSinglePayment.getUltimateDebtor());
            payments.setInstructedAmount(this.accountMapper.mapToAmount(spiSinglePayment.getInstructedAmount()));
            payments.setCreditorAccount(this.accountMapper.mapToAccountReference(spiSinglePayment.getCreditorAccount()));
            payments.setCreditorAgent(this.mapToBICFI(spiSinglePayment.getCreditorAgent()));
            payments.setCreditorName(spiSinglePayment.getCreditorName());
            payments.setCreditorAddress(this.mapToAddress(spiSinglePayment.getCreditorAddress()));
            payments.setUltimateCreditor(spiSinglePayment.getUltimateCreditor());
            payments.setPurposeCode(this.mapToPurposeCode(spiSinglePayment.getPurposeCode()));
            payments.setRemittanceInformationUnstructured(spiSinglePayment.getRemittanceInformationUnstructured());
            payments.setRemittanceInformationStructured(this.mapToRemittance(spiSinglePayment.getRemittanceInformationStructured()));
            payments.setRequestedExecutionDate(spiSinglePayment.getRequestedExecutionDate());
            payments.setRequestedExecutionTime(spiSinglePayment.getRequestedExecutionTime());
            return payments;
        }).orElse(null);
    }

    public PeriodicPayment mapToPeriodicPayment(SpiPeriodicPayment spiPeriodicPayment) {
        return Optional.ofNullable(spiPeriodicPayment).map(sp -> {
            PeriodicPayment payment = new PeriodicPayment();
            payment.setEndToEndIdentification(sp.getEndToEndIdentification());
            payment.setDebtorAccount(this.accountMapper.mapToAccountReference(sp.getDebtorAccount()));
            payment.setUltimateDebtor(sp.getUltimateDebtor());
            payment.setInstructedAmount(this.accountMapper.mapToAmount(sp.getInstructedAmount()));
            payment.setCreditorAccount(this.accountMapper.mapToAccountReference(sp.getCreditorAccount()));
            payment.setCreditorAgent(this.mapToBICFI(sp.getCreditorAgent()));
            payment.setCreditorName(sp.getCreditorName());
            payment.setCreditorAddress(this.mapToAddress(sp.getCreditorAddress()));
            payment.setUltimateCreditor(sp.getUltimateCreditor());
            payment.setPurposeCode(this.mapToPurposeCode(sp.getPurposeCode()));
            payment.setRemittanceInformationUnstructured(sp.getRemittanceInformationUnstructured());
            payment.setRemittanceInformationStructured(this.mapToRemittance(sp.getRemittanceInformationStructured()));
            payment.setRequestedExecutionDate(sp.getRequestedExecutionDate());
            payment.setRequestedExecutionTime(sp.getRequestedExecutionTime());
            payment.setExecutionRule(sp.getExecutionRule());
            payment.setFrequency(FrequencyCode.valueOf(sp.getFrequency()));
            payment.setDayOfExecution(sp.getDayOfExecution());
            payment.setEndDate(sp.getEndDate());
            payment.setStartDate(sp.getStartDate());
            return payment;
        }).orElse(null);
    }

    public List<SinglePayment> mapToBulkPayment(List<SpiSinglePayment> spiSinglePayment) {
        return CollectionUtils.isNotEmpty(spiSinglePayment) ? spiSinglePayment.stream().map(this::mapToSinglePayment).collect(Collectors.toList()) : null;
    }

    private AuthenticationObject[] mapToAuthenticationObjects(String[] authObjects) {
        return new AuthenticationObject[0];
    }

    private MessageErrorCode[] mapToMessageCodes(String[] messageCodes) {
        return new MessageErrorCode[0];
    }

    private SpiAddress mapToSpiAddress(Address address) {
        return Optional.ofNullable(address).map(a -> new SpiAddress(a.getStreet(), a.getBuildingNumber(), a.getCity(), a.getPostalCode(), Optional.ofNullable(a.getCountry()).map(CountryCode::getCode).orElse(""))).orElse(null);
    }

    private SpiRemittance mapToSpiRemittance(Remittance remittance) {
        return Optional.ofNullable(remittance).map(r -> {
            SpiRemittance spiRemittance = new SpiRemittance();
            spiRemittance.setReference(r.getReference());
            spiRemittance.setReferenceType(r.getReferenceType());
            spiRemittance.setReferenceIssuer(r.getReferenceIssuer());
            return spiRemittance;
        }).orElse(null);
    }

    private PurposeCode mapToPurposeCode(String purposeCode) {
        return Optional.ofNullable(purposeCode).map(p -> {
            PurposeCode code = new PurposeCode();
            code.setCode((String)p);
            return code;
        }).orElseGet(PurposeCode::new);
    }

    private Remittance mapToRemittance(SpiRemittance remittanceInformationStructured) {
        return Optional.ofNullable(remittanceInformationStructured).map(r -> {
            Remittance remittance = new Remittance();
            remittance.setReference(r.getReference());
            remittance.setReferenceIssuer(r.getReferenceIssuer());
            remittance.setReferenceType(r.getReferenceType());
            return remittance;
        }).orElseGet(Remittance::new);
    }

    private Address mapToAddress(SpiAddress creditorAddress) {
        return Optional.ofNullable(creditorAddress).map(a -> {
            Address address = new Address();
            CountryCode code = new CountryCode();
            code.setCode(Optional.ofNullable(a.getCountry()).orElse(null));
            address.setCountry(code);
            address.setPostalCode(a.getPostalCode());
            address.setCity(a.getCity());
            address.setStreet(a.getStreet());
            address.setBuildingNumber(a.getBuildingNumber());
            return address;
        }).orElseGet(Address::new);
    }

    private BICFI mapToBICFI(String creditorAgent) {
        BICFI bicfi = new BICFI();
        bicfi.setCode(creditorAgent);
        return bicfi;
    }

    private SpiAmount mapToSpiAmount(Amount amount) {
        return Optional.ofNullable(amount).map(am -> new SpiAmount(am.getCurrency(), new BigDecimal(am.getContent()))).orElse(null);
    }

    public TppInfo mapToTppInfo(String tppSignatureCertificate) {
        if (StringUtils.isBlank((CharSequence)tppSignatureCertificate)) {
            return null;
        }
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(tppSignatureCertificate);
            String decodedJson = new String(decodedBytes);
            return (TppInfo)this.objectMapper.readValue(decodedJson, TppInfo.class);
        }
        catch (Exception e) {
            log.warn("Error with converting TppInfo from certificate {}", (Object)tppSignatureCertificate);
            return null;
        }
    }

    @ConstructorProperties(value={"objectMapper", "accountMapper"})
    public PaymentMapper(ObjectMapper objectMapper, AccountMapper accountMapper) {
        this.objectMapper = objectMapper;
        this.accountMapper = accountMapper;
    }
}

