/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.aspsp.xs2a.domain.account.AccountReference;
import de.adorsys.aspsp.xs2a.domain.fund.FundsConfirmationRequest;
import de.adorsys.aspsp.xs2a.service.mapper.AmountModelMapper;
import de.adorsys.psd2.model.ConfirmationOfFunds;
import java.util.Optional;

public class FundsConfirmationModelMapper {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static FundsConfirmationRequest mapToFundsConfirmationRequest(ConfirmationOfFunds confirmationOfFunds) {
        return Optional.ofNullable(confirmationOfFunds).map(conf -> {
            FundsConfirmationRequest fundsConfirmationRequest = new FundsConfirmationRequest();
            fundsConfirmationRequest.setCardNumber(conf.getCardNumber());
            fundsConfirmationRequest.setPayee(conf.getPayee());
            fundsConfirmationRequest.setPsuAccount(FundsConfirmationModelMapper.mapToXs2aAccountReferenceInner(conf.getAccount()));
            fundsConfirmationRequest.setInstructedAmount(AmountModelMapper.mapToXs2aAmount(conf.getInstructedAmount()));
            return fundsConfirmationRequest;
        }).orElse(null);
    }

    private static AccountReference mapToXs2aAccountReferenceInner(Object reference) {
        return (AccountReference)OBJECT_MAPPER.convertValue(reference, AccountReference.class);
    }
}

