/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.aspsp.xs2a.domain.account.AccountReference;
import de.adorsys.aspsp.xs2a.domain.consent.AccountAccessType;
import de.adorsys.aspsp.xs2a.domain.consent.AccountConsent;
import de.adorsys.aspsp.xs2a.domain.consent.ConsentStatusResponse;
import de.adorsys.aspsp.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.aspsp.xs2a.domain.consent.CreateConsentResponse;
import de.adorsys.psd2.model.AccountAccess;
import de.adorsys.psd2.model.AuthenticationObject;
import de.adorsys.psd2.model.AuthenticationType;
import de.adorsys.psd2.model.ConsentInformationResponse200Json;
import de.adorsys.psd2.model.ConsentStatus;
import de.adorsys.psd2.model.ConsentStatusResponse200;
import de.adorsys.psd2.model.Consents;
import de.adorsys.psd2.model.ConsentsResponse201;
import de.adorsys.psd2.model.ScaMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;

public class ConsentModelMapper {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static CreateConsentReq mapToCreateConsentReq(Consents consent) {
        return Optional.ofNullable(consent).map(cnst -> {
            CreateConsentReq createAisConsentRequest = new CreateConsentReq();
            createAisConsentRequest.setAccess(ConsentModelMapper.mapToAccountAccessInner(cnst.getAccess()));
            createAisConsentRequest.setRecurringIndicator(cnst.getRecurringIndicator());
            createAisConsentRequest.setValidUntil(cnst.getValidUntil());
            createAisConsentRequest.setFrequencyPerDay(cnst.getFrequencyPerDay());
            createAisConsentRequest.setCombinedServiceIndicator(BooleanUtils.toBoolean((Boolean)cnst.isCombinedServiceIndicator()));
            return createAisConsentRequest;
        }).orElse(null);
    }

    public static ConsentStatusResponse200 mapToConsentStatusResponse200(ConsentStatusResponse consentStatusResponse) {
        return Optional.ofNullable(consentStatusResponse).map(cstr -> new ConsentStatusResponse200().consentStatus(ConsentStatus.fromValue((String)cstr.getConsentStatus()))).orElse(null);
    }

    public static ConsentsResponse201 mapToConsentsResponse201(CreateConsentResponse createConsentResponse) {
        return Optional.ofNullable(createConsentResponse).map(cnst -> new ConsentsResponse201().consentStatus(ConsentStatus.fromValue((String)cnst.getConsentStatus())).consentId(cnst.getConsentId()).scaMethods(ConsentModelMapper.mapToScaMethodsOuter(cnst))._links((Map)OBJECT_MAPPER.convertValue((Object)cnst.getLinks(), Map.class)).message(cnst.getPsuMessage())).orElse(null);
    }

    public static ConsentInformationResponse200Json mapToConsentInformationResponse200Json(AccountConsent accountConsent) {
        return Optional.ofNullable(accountConsent).map(consent -> new ConsentInformationResponse200Json().access(ConsentModelMapper.mapToAccountAccessDomain(consent.getAccess())).recurringIndicator(Boolean.valueOf(consent.isRecurringIndicator())).validUntil(consent.getValidUntil()).frequencyPerDay(Integer.valueOf(consent.getFrequencyPerDay())).lastActionDate(consent.getLastActionDate()).consentStatus(ConsentStatus.fromValue((String)consent.getConsentStatus().getValue()))).orElse(null);
    }

    private static ScaMethods mapToScaMethodsOuter(CreateConsentResponse createConsentResponse) {
        List authList = Optional.ofNullable(createConsentResponse.getScaMethods()).map(arr -> Arrays.stream(createConsentResponse.getScaMethods()).map(au -> new AuthenticationObject().authenticationType(AuthenticationType.fromValue((String)au.getAuthenticationType().getDescription())).authenticationVersion(au.getAuthenticationVersion()).authenticationMethodId(au.getAuthenticationMethodId()).name(au.getName()).explanation(au.getExplanation())).collect(Collectors.toList())).orElse(Collections.emptyList());
        ScaMethods scaMethods = new ScaMethods();
        scaMethods.addAll(authList);
        return scaMethods;
    }

    private static de.adorsys.aspsp.xs2a.domain.consent.AccountAccess mapToAccountAccessInner(AccountAccess accountAccess) {
        return Optional.ofNullable(accountAccess).map(acs -> new de.adorsys.aspsp.xs2a.domain.consent.AccountAccess(ConsentModelMapper.mapToAccountReferencesInner(acs.getAccounts()), ConsentModelMapper.mapToAccountReferencesInner(acs.getBalances()), ConsentModelMapper.mapToAccountReferencesInner(acs.getTransactions()), ConsentModelMapper.mapToAccountAccessTypeFromAvailableAccounts(acs.getAvailableAccounts()), ConsentModelMapper.mapToAccountAccessTypeFromAllPsd2Enum(acs.getAllPsd2()))).orElse(null);
    }

    private static AccountAccess mapToAccountAccessDomain(de.adorsys.aspsp.xs2a.domain.consent.AccountAccess accountAccess) {
        return Optional.ofNullable(accountAccess).map(access -> {
            AccountAccess mappedAccountAccess = new AccountAccess();
            mappedAccountAccess.setAccounts(new ArrayList<AccountReference>(access.getAccounts()));
            mappedAccountAccess.setBalances(new ArrayList<AccountReference>(access.getBalances()));
            mappedAccountAccess.setTransactions(new ArrayList<AccountReference>(access.getTransactions()));
            mappedAccountAccess.setAvailableAccounts(AccountAccess.AvailableAccountsEnum.fromValue((String)Optional.ofNullable(access.getAvailableAccounts()).map(AccountAccessType::getDescription).orElse(null)));
            mappedAccountAccess.setAllPsd2(AccountAccess.AllPsd2Enum.fromValue((String)Optional.ofNullable(access.getAllPsd2()).map(AccountAccessType::getDescription).orElse(null)));
            return mappedAccountAccess;
        }).orElse(null);
    }

    private static AccountAccessType mapToAccountAccessTypeFromAvailableAccounts(AccountAccess.AvailableAccountsEnum accountsEnum) {
        return Optional.ofNullable(accountsEnum).flatMap(en -> AccountAccessType.getByDescription(en.toString())).orElse(null);
    }

    private static AccountAccessType mapToAccountAccessTypeFromAllPsd2Enum(AccountAccess.AllPsd2Enum allPsd2Enum) {
        return Optional.ofNullable(allPsd2Enum).flatMap(en -> AccountAccessType.getByDescription(en.toString())).orElse(null);
    }

    private static List<AccountReference> mapToAccountReferencesInner(List<Object> references) {
        return Optional.ofNullable(references).map(ref -> ref.stream().map(ConsentModelMapper::mapToAccountReferenceInner).collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }

    private static AccountReference mapToAccountReferenceInner(Object reference) {
        return (AccountReference)OBJECT_MAPPER.convertValue(reference, AccountReference.class);
    }
}

