/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.mapper;

import de.adorsys.aspsp.xs2a.domain.Amount;
import java.util.Currency;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class AmountModelMapper {
    public static Amount mapToXs2aAmount(de.adorsys.psd2.model.Amount amount) {
        return Optional.ofNullable(amount).map(a -> {
            Amount amountTarget = new Amount();
            amountTarget.setContent(a.getAmount());
            amountTarget.setCurrency(AmountModelMapper.getCurrencyByCode(a.getCurrency()));
            return amountTarget;
        }).orElse(null);
    }

    public static de.adorsys.psd2.model.Amount mapToAmount(Amount amount) {
        return Optional.ofNullable(amount).map(a -> {
            de.adorsys.psd2.model.Amount amountTarget = new de.adorsys.psd2.model.Amount();
            amountTarget.setAmount(a.getContent());
            amountTarget.setCurrency(a.getCurrency().getCurrencyCode());
            return amountTarget;
        }).orElse(null);
    }

    private static Currency getCurrencyByCode(String code) {
        return StringUtils.isNotBlank((CharSequence)code) ? Currency.getInstance(code) : null;
    }
}

