/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.aspsp.xs2a.domain.Amount;
import de.adorsys.aspsp.xs2a.domain.Balance;
import de.adorsys.aspsp.xs2a.domain.Transactions;
import de.adorsys.aspsp.xs2a.domain.account.AccountDetails;
import de.adorsys.aspsp.xs2a.domain.account.AccountReference;
import de.adorsys.aspsp.xs2a.domain.address.CountryCode;
import de.adorsys.aspsp.xs2a.service.mapper.AmountModelMapper;
import de.adorsys.psd2.model.AccountList;
import de.adorsys.psd2.model.AccountReferenceBban;
import de.adorsys.psd2.model.AccountReferenceIban;
import de.adorsys.psd2.model.AccountReferenceMaskedPan;
import de.adorsys.psd2.model.AccountReferenceMsisdn;
import de.adorsys.psd2.model.AccountReferencePan;
import de.adorsys.psd2.model.AccountReport;
import de.adorsys.psd2.model.Address;
import de.adorsys.psd2.model.BalanceList;
import de.adorsys.psd2.model.BalanceType;
import de.adorsys.psd2.model.PurposeCode;
import de.adorsys.psd2.model.ReadBalanceResponse200;
import de.adorsys.psd2.model.TransactionDetails;
import de.adorsys.psd2.model.TransactionList;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public final class AccountModelMapper {
    private static final Logger log = LoggerFactory.getLogger(AccountModelMapper.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static AccountList mapToAccountList(Map<String, List<AccountDetails>> accountDetailsList) {
        List details = accountDetailsList.values().stream().flatMap(ad -> ad.stream().map(AccountModelMapper::mapToAccountDetails)).collect(Collectors.toList());
        return new AccountList().accounts(details);
    }

    public static de.adorsys.psd2.model.AccountDetails mapToAccountDetails(AccountDetails accountDetails) {
        de.adorsys.psd2.model.AccountDetails target = new de.adorsys.psd2.model.AccountDetails();
        BeanUtils.copyProperties((Object)accountDetails, (Object)target);
        target.resourceId(accountDetails.getId()).currency(accountDetails.getCurrency().getCurrencyCode()).cashAccountType((String)Optional.ofNullable(accountDetails.getCashAccountType()).map(Enum::name).orElse(null));
        return target.balances(AccountModelMapper.mapToBalanceList(accountDetails.getBalances()))._links((Map)OBJECT_MAPPER.convertValue((Object)accountDetails.getLinks(), Map.class));
    }

    private static BalanceList mapToBalanceList(List<Balance> balances) {
        BalanceList balanceList = null;
        if (CollectionUtils.isNotEmpty(balances)) {
            balanceList = new BalanceList();
            balanceList.addAll((Collection)balances.stream().map(AccountModelMapper::mapToBalance).collect(Collectors.toList()));
        }
        return balanceList;
    }

    public static ReadBalanceResponse200 mapToBalance(List<Balance> balances) {
        BalanceList balancesResponse = new BalanceList();
        balances.forEach(balance -> balancesResponse.add((Object)AccountModelMapper.mapToBalance(balance)));
        return new ReadBalanceResponse200().balances(balancesResponse);
    }

    public static de.adorsys.psd2.model.Balance mapToBalance(Balance balance) {
        de.adorsys.psd2.model.Balance target = new de.adorsys.psd2.model.Balance();
        BeanUtils.copyProperties((Object)balance, (Object)target);
        target.setBalanceAmount(AmountModelMapper.mapToAmount(balance.getBalanceAmount()));
        Optional.ofNullable(balance.getBalanceType()).ifPresent(balanceType -> target.setBalanceType(BalanceType.fromValue((String)balanceType.getValue())));
        Optional.ofNullable(balance.getLastChangeDateTime()).ifPresent(lastChangeDateTime -> {
            List<ZoneOffset> validOffsets = ZoneId.systemDefault().getRules().getValidOffsets((LocalDateTime)lastChangeDateTime);
            target.setLastChangeDateTime(lastChangeDateTime.atOffset(validOffsets.get(0)));
        });
        return target;
    }

    public static de.adorsys.psd2.model.Amount mapToAmount(Amount amount) {
        return Optional.ofNullable(amount).map(a -> new de.adorsys.psd2.model.Amount().amount(a.getContent()).currency(a.getCurrency().getCurrencyCode())).orElse(new de.adorsys.psd2.model.Amount());
    }

    public static AccountReport mapToAccountReport(de.adorsys.aspsp.xs2a.domain.account.AccountReport accountReport) {
        TransactionList booked = new TransactionList();
        List bookedTransactions = Optional.ofNullable(accountReport.getBooked()).map(ts -> Arrays.stream(ts).map(AccountModelMapper::mapToTransaction).collect(Collectors.toList())).orElse(new ArrayList());
        booked.addAll((Collection)bookedTransactions);
        TransactionList pending = new TransactionList();
        List pendingTransactions = Optional.ofNullable(accountReport.getPending()).map(ts -> Arrays.stream(ts).map(AccountModelMapper::mapToTransaction).collect(Collectors.toList())).orElse(new ArrayList());
        pending.addAll((Collection)pendingTransactions);
        return new AccountReport().booked(booked).pending(pending)._links((Map)OBJECT_MAPPER.convertValue((Object)accountReport.getLinks(), Map.class));
    }

    public static TransactionDetails mapToTransaction(Transactions transactions) {
        TransactionDetails target = new TransactionDetails();
        BeanUtils.copyProperties((Object)transactions, (Object)target);
        target.setCreditorAccount(AccountModelMapper.createAccountObject(transactions.getCreditorAccount()));
        target.setDebtorAccount(AccountModelMapper.createAccountObject(transactions.getDebtorAccount()));
        Optional.ofNullable(transactions.getAmount()).ifPresent(amount -> target.setTransactionAmount(AmountModelMapper.mapToAmount(amount)));
        target.setPurposeCode(PurposeCode.fromValue((String)Optional.ofNullable(transactions.getPurposeCode()).map(de.adorsys.aspsp.xs2a.domain.code.PurposeCode::getCode).orElse(null)));
        Optional.ofNullable(transactions.getBankTransactionCodeCode()).ifPresent(transactionCode -> target.setBankTransactionCode(transactionCode.getCode()));
        return target;
    }

    public static <T> T mapToAccountReference12(AccountReference reference) {
        AccountReferenceIban accountReference = null;
        if (StringUtils.isNotBlank((CharSequence)reference.getIban())) {
            accountReference = new AccountReferenceIban().iban(reference.getIban());
            accountReference.setCurrency(reference.getCurrency().getCurrencyCode());
        } else if (StringUtils.isNotBlank((CharSequence)reference.getBban())) {
            accountReference = new AccountReferenceBban().bban(reference.getBban());
            ((AccountReferenceBban)accountReference).setCurrency(reference.getCurrency().getCurrencyCode());
        } else if (StringUtils.isNotBlank((CharSequence)reference.getPan())) {
            accountReference = new AccountReferencePan().pan(reference.getPan());
            ((AccountReferencePan)accountReference).setCurrency(reference.getCurrency().getCurrencyCode());
        } else if (StringUtils.isNotBlank((CharSequence)reference.getMaskedPan())) {
            accountReference = new AccountReferenceMaskedPan().maskedPan(reference.getMaskedPan());
            ((AccountReferenceMaskedPan)accountReference).setCurrency(reference.getCurrency().getCurrencyCode());
        } else if (StringUtils.isNotBlank((CharSequence)reference.getMsisdn())) {
            accountReference = new AccountReferenceMsisdn().msisdn(reference.getMsisdn());
            ((AccountReferenceMsisdn)accountReference).setCurrency(reference.getCurrency().getCurrencyCode());
        }
        return (T)accountReference;
    }

    public static Address mapToAddress12(de.adorsys.aspsp.xs2a.domain.address.Address address) {
        Address targetAddress = new Address().street(address.getStreet());
        targetAddress.setStreet(address.getStreet());
        targetAddress.setBuildingNumber(address.getBuildingNumber());
        targetAddress.setCity(address.getCity());
        targetAddress.setPostalCode(address.getPostalCode());
        targetAddress.setCountry(address.getCountry().getCode());
        return targetAddress;
    }

    public static de.adorsys.aspsp.xs2a.domain.address.Address mapToXs2aAddress(Address address) {
        return Optional.ofNullable(address).map(a -> {
            de.adorsys.aspsp.xs2a.domain.address.Address targetAddress = new de.adorsys.aspsp.xs2a.domain.address.Address();
            targetAddress.setStreet(a.getStreet());
            targetAddress.setBuildingNumber(a.getBuildingNumber());
            targetAddress.setCity(a.getCity());
            targetAddress.setPostalCode(a.getPostalCode());
            CountryCode code = new CountryCode();
            code.setCode(a.getCountry());
            targetAddress.setCountry(code);
            return targetAddress;
        }).orElse(new de.adorsys.aspsp.xs2a.domain.address.Address());
    }

    public static Amount mapToXs2aAmount(de.adorsys.psd2.model.Amount amount) {
        return Optional.ofNullable(amount).map(a -> {
            Amount targetAmount = new Amount();
            targetAmount.setContent(a.getAmount());
            targetAmount.setCurrency(Currency.getInstance(a.getCurrency()));
            return targetAmount;
        }).orElse(new Amount());
    }

    private static Object createAccountObject(AccountReference accountReference) {
        return Optional.ofNullable(accountReference).map(account -> {
            if (account.getIban() != null) {
                return new AccountReferenceIban().iban(accountReference.getIban()).currency(AccountModelMapper.getCurrencyFromAccountReference(accountReference));
            }
            if (account.getBban() != null) {
                return new AccountReferenceBban().bban(accountReference.getBban()).currency(AccountModelMapper.getCurrencyFromAccountReference(accountReference));
            }
            if (account.getPan() != null) {
                return new AccountReferencePan().pan(accountReference.getPan()).currency(AccountModelMapper.getCurrencyFromAccountReference(accountReference));
            }
            if (account.getMsisdn() != null) {
                return new AccountReferenceMsisdn().msisdn(accountReference.getMsisdn()).currency(AccountModelMapper.getCurrencyFromAccountReference(accountReference));
            }
            if (account.getMaskedPan() != null) {
                return new AccountReferenceMaskedPan().maskedPan(accountReference.getMaskedPan()).currency(AccountModelMapper.getCurrencyFromAccountReference(accountReference));
            }
            return null;
        }).orElse(null);
    }

    private static String getCurrencyFromAccountReference(AccountReference accountReference) {
        return Optional.ofNullable(accountReference.getCurrency()).map(Currency::getCurrencyCode).orElse(null);
    }
}

