/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.keycloak;

import de.adorsys.aspsp.xs2a.config.KeycloakConfigProperties;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class KeycloakInvokerService {
    @Autowired
    private KeycloakConfigProperties keycloakConfig;
    @Autowired
    @Qualifier(value="keycloakRestTemplate")
    private RestTemplate keycloakRestTemplate;
    @Value(value="${keycloak-username}")
    private String keycloakUsername;
    @Value(value="${keycloak-password}")
    private String keycloakPassword;

    public String obtainAccessToken() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)"password");
        map.add((Object)"username", (Object)this.keycloakUsername);
        map.add((Object)"password", (Object)this.keycloakPassword);
        map.add((Object)"client_id", (Object)this.keycloakConfig.getResource());
        map.add((Object)"client_secret", (Object)this.keycloakConfig.getCredentials().getSecret());
        ResponseEntity response = this.keycloakRestTemplate.exchange(this.keycloakConfig.getRootPath() + "/protocol/openid-connect/token", HttpMethod.POST, new HttpEntity((Object)map, (MultiValueMap)headers), (ParameterizedTypeReference)new ParameterizedTypeReference<HashMap<String, String>>(){}, new Object[0]);
        String accessToken = null;
        if (response.getBody() != null) {
            accessToken = "Authorization: Bearer " + (String)((HashMap)response.getBody()).get("access_token");
        }
        return accessToken;
    }
}

