/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service;

import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.domain.ResponseObject;
import de.adorsys.aspsp.xs2a.domain.TppMessageInformation;
import de.adorsys.aspsp.xs2a.domain.TransactionStatus;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentProduct;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentType;
import de.adorsys.aspsp.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.aspsp.xs2a.domain.pis.SinglePayment;
import de.adorsys.aspsp.xs2a.exception.MessageCategory;
import de.adorsys.aspsp.xs2a.exception.MessageError;
import de.adorsys.aspsp.xs2a.service.mapper.PaymentMapper;
import de.adorsys.aspsp.xs2a.service.payment.ReadPayment;
import de.adorsys.aspsp.xs2a.service.payment.ReadPaymentFactory;
import de.adorsys.aspsp.xs2a.service.payment.ScaPaymentService;
import de.adorsys.aspsp.xs2a.spi.domain.common.SpiTransactionStatus;
import de.adorsys.aspsp.xs2a.spi.domain.consent.AspspConsentData;
import de.adorsys.aspsp.xs2a.spi.service.PaymentSpi;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PaymentService {
    private static final Logger log = LoggerFactory.getLogger(PaymentService.class);
    private final PaymentSpi paymentSpi;
    private final PaymentMapper paymentMapper;
    private final ScaPaymentService scaPaymentService;
    private final ReadPaymentFactory readPaymentFactory;

    public ResponseObject<TransactionStatus> getPaymentStatusById(String paymentId, PaymentType paymentType) {
        TransactionStatus transactionStatus = this.paymentMapper.mapToTransactionStatus((SpiTransactionStatus)this.paymentSpi.getPaymentStatusById(paymentId, this.paymentMapper.mapToSpiPaymentType(paymentType), new AspspConsentData()).getPayload());
        return Optional.ofNullable(transactionStatus).map(tr -> ResponseObject.builder().body((TransactionStatus)((Object)tr)).build()).orElseGet(() -> ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_403))).build());
    }

    public ResponseObject<PaymentInitialisationResponse> initiatePeriodicPayment(PeriodicPayment periodicPayment, String tppSignatureCertificate, String paymentProduct) {
        return periodicPayment.areValidExecutionAndPeriodDates() ? ResponseObject.builder().body(this.scaPaymentService.createPeriodicPayment(periodicPayment, this.paymentMapper.mapToTppInfo(tppSignatureCertificate), paymentProduct)).build() : this.mapToFailResponse(periodicPayment, MessageErrorCode.EXECUTION_DATE_INVALID);
    }

    public ResponseObject<List<PaymentInitialisationResponse>> createBulkPayments(List<SinglePayment> payments, String tppSignatureCertificate, String paymentProduct) {
        List<PaymentInitialisationResponse> paymentResponses;
        if (CollectionUtils.isEmpty(payments)) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.FORMAT_ERROR))).build();
        }
        ArrayList<SinglePayment> validPayments = new ArrayList<SinglePayment>();
        ArrayList<PaymentInitialisationResponse> invalidPayments = new ArrayList<PaymentInitialisationResponse>();
        for (SinglePayment payment : payments) {
            if (payment.isValidExecutionDateAndTime()) {
                validPayments.add(payment);
                continue;
            }
            invalidPayments.add(this.paymentMapper.mapToPaymentInitResponseFailedPayment(payment, MessageErrorCode.EXECUTION_DATE_INVALID));
        }
        if (CollectionUtils.isNotEmpty(validPayments) && CollectionUtils.isNotEmpty(paymentResponses = this.scaPaymentService.createBulkPayment(validPayments, this.paymentMapper.mapToTppInfo(tppSignatureCertificate), paymentProduct)) && paymentResponses.stream().anyMatch(pr -> pr.getTransactionStatus() != TransactionStatus.RJCT)) {
            paymentResponses.addAll(invalidPayments);
            return ResponseObject.builder().body(paymentResponses).build();
        }
        return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.PAYMENT_FAILED))).build();
    }

    public ResponseObject<PaymentInitialisationResponse> createPaymentInitiation(SinglePayment singlePayment, String tppSignatureCertificate, String paymentProduct) {
        return singlePayment.isValidExecutionDateAndTime() ? ResponseObject.builder().body(this.scaPaymentService.createSinglePayment(singlePayment, this.paymentMapper.mapToTppInfo(tppSignatureCertificate), paymentProduct)).build() : this.mapToFailResponse(singlePayment, MessageErrorCode.EXECUTION_DATE_INVALID);
    }

    public ResponseObject<Object> getPaymentById(PaymentType paymentType, String paymentId) {
        ReadPayment service = this.readPaymentFactory.getService(paymentType.getValue());
        Optional payment = Optional.ofNullable(service.getPayment(paymentId, "TMP"));
        return payment.isPresent() ? ResponseObject.builder().body(payment.get()).build() : ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_403))).build();
    }

    public <T, R> ResponseObject<R> createPayment(T payment, PaymentType paymentType, PaymentProduct paymentProduct, String tppSignatureCertificate) {
        ResponseObject<Object> response = paymentType == PaymentType.SINGLE ? this.createPaymentInitiation((SinglePayment)payment, tppSignatureCertificate, paymentProduct.getCode()) : (paymentType == PaymentType.PERIODIC ? this.initiatePeriodicPayment((PeriodicPayment)payment, tppSignatureCertificate, paymentProduct.getCode()) : this.createBulkPayments((List)payment, tppSignatureCertificate, paymentProduct.getCode()));
        return response;
    }

    private ResponseObject<PaymentInitialisationResponse> mapToFailResponse(SinglePayment payment, MessageErrorCode errorCode) {
        PaymentInitialisationResponse response = this.paymentMapper.mapToPaymentInitResponseFailedPayment(payment, errorCode);
        return ResponseObject.builder().body(response).build();
    }

    @ConstructorProperties(value={"paymentSpi", "paymentMapper", "scaPaymentService", "readPaymentFactory"})
    public PaymentService(PaymentSpi paymentSpi, PaymentMapper paymentMapper, ScaPaymentService scaPaymentService, ReadPaymentFactory readPaymentFactory) {
        this.paymentSpi = paymentSpi;
        this.paymentMapper = paymentMapper;
        this.scaPaymentService = scaPaymentService;
        this.readPaymentFactory = readPaymentFactory;
    }
}

